/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.NullableVarBinaryWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.apache.drill.exec.vector.complex.writer.VarBinaryWriter;

public class NullableVarBinaryReaderImpl
extends AbstractFieldReader {
    private final NullableVarBinaryVector vector;

    public NullableVarBinaryReaderImpl(NullableVarBinaryVector vector) {
        this.vector = vector;
    }

    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public boolean isSet() {
        return !this.vector.getAccessor().isNull(this.idx());
    }

    @Override
    public void copyAsValue(VarBinaryWriter writer) {
        NullableVarBinaryWriterImpl impl = (NullableVarBinaryWriterImpl)((Object)writer);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        NullableVarBinaryWriterImpl impl = (NullableVarBinaryWriterImpl)((Object)writer.varBinary(name));
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(NullableVarBinaryHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public byte[] readByteArray() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

