/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.joda.time.Period;

public class NullableIntervalDayHolderReaderImpl
extends AbstractFieldReader {
    private NullableIntervalDayHolder holder;

    public NullableIntervalDayHolderReaderImpl(NullableIntervalDayHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    public TypeProtos.MajorType getType() {
        return NullableIntervalDayHolder.TYPE;
    }

    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public Period readPeriod() {
        if (!this.isSet()) {
            return null;
        }
        Period p = new Period();
        return p.plusDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        Period p = new Period();
        return p.plusDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }
}

