/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.NullableIntWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.apache.drill.exec.vector.complex.writer.IntWriter;

public class NullableIntReaderImpl
extends AbstractFieldReader {
    private final NullableIntVector vector;

    public NullableIntReaderImpl(NullableIntVector vector) {
        this.vector = vector;
    }

    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public boolean isSet() {
        return !this.vector.getAccessor().isNull(this.idx());
    }

    @Override
    public void copyAsValue(IntWriter writer) {
        NullableIntWriterImpl impl = (NullableIntWriterImpl)((Object)writer);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        NullableIntWriterImpl impl = (NullableIntWriterImpl)((Object)writer.integer(name));
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(NullableIntHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public Integer readInteger() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

