/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.NullableDecimal9Vector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class NullableDecimal9WriterImpl
extends AbstractFieldWriter {
    private final NullableDecimal9Vector.Mutator mutator;
    final NullableDecimal9Vector vector;

    public NullableDecimal9WriterImpl(NullableDecimal9Vector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    public void allocate() {
        this.vector.allocateNew();
    }

    public void close() {
        this.vector.close();
    }

    public void clear() {
        this.vector.clear();
    }

    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(Decimal9Holder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableDecimal9Holder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

