/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class NullableBitWriterImpl
extends AbstractFieldWriter {
    private final NullableBitVector.Mutator mutator;
    final NullableBitVector vector;

    public NullableBitWriterImpl(NullableBitVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    public void allocate() {
        this.vector.allocateNew();
    }

    public void close() {
        this.vector.close();
    }

    public void clear() {
        this.vector.clear();
    }

    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(BitHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableBitHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeBit(int value) {
        this.mutator.setSafe(this.idx(), 1, value);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.mutator.setNull(this.idx());
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

