/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.Float4Vector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.Float4WriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.apache.drill.exec.vector.complex.writer.Float4Writer;

public class Float4ReaderImpl
extends AbstractFieldReader {
    private final Float4Vector vector;

    public Float4ReaderImpl(Float4Vector vector) {
        this.vector = vector;
    }

    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(Float4Writer writer) {
        Float4WriterImpl impl = (Float4WriterImpl)((Object)writer);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        Float4WriterImpl impl = (Float4WriterImpl)((Object)writer.float4(name));
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(NullableFloat4Holder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public Float readFloat() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

