/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.DateVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class DateWriterImpl
extends AbstractFieldWriter {
    private final DateVector.Mutator mutator;
    final DateVector vector;

    public DateWriterImpl(DateVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    public void allocate() {
        this.vector.allocateNew();
    }

    public void close() {
        this.vector.close();
    }

    public void clear() {
        this.vector.clear();
    }

    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(DateHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableDateHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeDate(long value) {
        this.mutator.setSafe(this.idx(), value);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

