/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.DateVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.DateWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.DateWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.joda.time.DateTime;

public class DateReaderImpl
extends AbstractFieldReader {
    private final DateVector vector;

    public DateReaderImpl(DateVector vector) {
        this.vector = vector;
    }

    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(DateWriter writer) {
        DateWriterImpl impl = (DateWriterImpl)((Object)writer);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        DateWriterImpl impl = (DateWriterImpl)((Object)writer.date(name));
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(NullableDateHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public DateTime readDateTime() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

