/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.BigIntWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.BigIntWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;

public class BigIntReaderImpl
extends AbstractFieldReader {
    private final BigIntVector vector;

    public BigIntReaderImpl(BigIntVector vector) {
        this.vector = vector;
    }

    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    public MaterializedField getField() {
        return this.vector.getField();
    }

    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(BigIntWriter writer) {
        BigIntWriterImpl impl = (BigIntWriterImpl)((Object)writer);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        BigIntWriterImpl impl = (BigIntWriterImpl)((Object)writer.bigInt(name));
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(NullableBigIntHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public Long readLong() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

