/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.fn;

import java.util.List;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.util.JsonStringHashMap;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonReaderWithSparseFiles
extends BaseTestQuery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void query(String query, Function<RecordBatchLoader> testBody) throws Exception {
        List<QueryDataBatch> batches = TestJsonReaderWithSparseFiles.testSqlWithResults(query);
        RecordBatchLoader loader = new RecordBatchLoader(client.getAllocator());
        try {
            QueryDataBatch batch = batches.get(0);
            loader.load(batch.getHeader().getDef(), batch.getData());
            testBody.apply(loader);
        }
        finally {
            for (QueryDataBatch batch : batches) {
                batch.release();
            }
            loader.clear();
        }
    }

    @Test
    public void testIfDrillCanReadSparseRecords() throws Exception {
        String sql = "select * from cp.`vector/complex/fn/sparse.json`";
        Object[][] values = new Object[][]{{null, null}, {1L, null}, {null, 2L}, {3L, 3L}};
        this.query("select * from cp.`vector/complex/fn/sparse.json`", new Verifier(4, values));
    }

    @Test
    public void testIfDrillCanReadSparseNestedRecordsWithoutRaisingException() throws Exception {
        String sql = "select * from cp.`vector/complex/fn/nested-with-nulls.json`";
        Object[][] values = new Object[][]{{"[{},{},{},{\"name\":\"doe\"},{}]"}, {"[]"}, {"[{\"name\":\"john\",\"id\":10}]"}, {"[{},{}]"}};
        this.query("select * from cp.`vector/complex/fn/nested-with-nulls.json`", new Verifier(4, values));
    }

    @Test
    public void testIfDrillCanQuerySingleRecordWithEmpties() throws Exception {
        String sql = "select * from cp.`vector/complex/fn/single-record-with-empties.json`";
        Object[][] values = new Object[][]{{"[{},{}]"}};
        this.query("select * from cp.`vector/complex/fn/single-record-with-empties.json`", new Verifier(1, values));
    }

    private static class Verifier
    implements Function<RecordBatchLoader> {
        private final int count;
        private final Object[][] values;
        private final TypeConverter converter = new TypeConverter();

        protected Verifier(int count, Object[][] values) {
            this.count = count;
            this.values = values;
        }

        @Override
        public void apply(RecordBatchLoader loader) {
            Assert.assertEquals((String)"invalid record count returned", (long)this.count, (long)loader.getRecordCount());
            for (int r = 0; r < this.values.length; ++r) {
                Object[] row = this.values[r];
                for (int c = 0; c < this.values[r].length; ++c) {
                    Object expected = row[c];
                    Object unconverted = loader.getValueAccessorById(ValueVector.class, new int[]{c}).getValueVector().getAccessor().getObject(r);
                    Object actual = this.converter.convert(unconverted);
                    Assert.assertEquals((String)String.format("row:%d - col:%d - expected:%s[%s] - actual:%s[%s]", r, c, expected, expected == null ? "null" : expected.getClass().getSimpleName(), actual, actual == null ? "null" : actual.getClass().getSimpleName()), (Object)actual, (Object)expected);
                }
            }
        }
    }

    private static class TypeConverter {
        private TypeConverter() {
        }

        public Object convert(Object obj) {
            if (obj instanceof JsonStringArrayList || obj instanceof JsonStringHashMap) {
                return obj.toString();
            }
            return obj;
        }
    }

    private static interface Function<T> {
        public void apply(T var1);
    }
}

