/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.TestBuilder;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import org.apache.drill.exec.vector.complex.EmptyValuePopulator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestEmptyPopulation
extends BaseTestQuery {
    private UInt4Vector offsets;
    private UInt4Vector.Accessor accessor;
    private UInt4Vector.Mutator mutator;
    private EmptyValuePopulator populator;
    private final DrillConfig drillConfig = DrillConfig.create();
    private final BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)this.drillConfig);

    @Before
    public void initialize() {
        this.offsets = new UInt4Vector(BaseRepeatedValueVector.OFFSETS_FIELD, this.allocator);
        this.offsets.allocateNewSafe();
        this.accessor = this.offsets.getAccessor();
        this.mutator = this.offsets.getMutator();
        this.mutator.set(0, 0);
        this.mutator.setValueCount(1);
        Assert.assertTrue((String)"offsets must have one value", (this.accessor.getValueCount() == 1 ? 1 : 0) != 0);
        this.populator = new EmptyValuePopulator(this.offsets);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testNegativeValuesThrowException() {
        this.populator.populate(-1);
    }

    @Test
    public void testZeroHasNoEffect() {
        this.populator.populate(0);
        Assert.assertTrue((String)"offset must have one value", (this.accessor.getValueCount() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyPopulationWorks() {
        this.populator.populate(1);
        Assert.assertEquals((String)"offset must have valid size", (long)2L, (long)this.accessor.getValueCount());
        Assert.assertEquals((String)"value must match", (long)0L, (long)this.accessor.get(1));
        this.mutator.set(1, 10);
        this.populator.populate(2);
        Assert.assertEquals((String)"offset must have valid size", (long)3L, (long)this.accessor.getValueCount());
        Assert.assertEquals((String)"value must match", (long)10L, (long)this.accessor.get(1));
        this.mutator.set(2, 20);
        this.populator.populate(5);
        Assert.assertEquals((String)"offset must have valid size", (long)6L, (long)this.accessor.getValueCount());
        for (int i = 2; i <= 5; ++i) {
            Assert.assertEquals((String)String.format("value at index[%s] must match", i), (long)20L, (long)this.accessor.get(i));
        }
        this.populator.populate(0);
        Assert.assertEquals((String)"offset must have valid size", (long)1L, (long)this.accessor.getValueCount());
        Assert.assertEquals((String)"value must match", (long)0L, (long)this.accessor.get(0));
    }

    @Test
    public void testRepeatedScalarEmptyFirst() throws Exception {
        String query = "select * from cp.`vector/complex/repeated-scalar-empty-first.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/repeated-scalar-empty-first.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(new Object[0])).baselineValues(TestBuilder.listOf(1L)).baselineValues(TestBuilder.listOf(2L)).go();
    }

    @Test
    public void testRepeatedScalarEmptyLast() throws Exception {
        String query = "select * from cp.`vector/complex/repeated-scalar-empty-last.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/repeated-scalar-empty-last.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(1L)).baselineValues(TestBuilder.listOf(2L)).baselineValues(TestBuilder.listOf(new Object[0])).go();
    }

    @Test
    public void testRepeatedScalarEmptyInBetween() throws Exception {
        String query = "select * from cp.`vector/complex/repeated-scalar-empty-between.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/repeated-scalar-empty-between.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(1L)).baselineValues(TestBuilder.listOf(new Object[0])).baselineValues(TestBuilder.listOf(2L)).go();
    }

    @Test
    public void testRepeatedListEmptyFirst() throws Exception {
        String query = "select * from cp.`vector/complex/repeated-list-empty-first.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/repeated-list-empty-first.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(new Object[0])).baselineValues(TestBuilder.listOf(TestBuilder.listOf(1L))).baselineValues(TestBuilder.listOf(TestBuilder.listOf(2L))).go();
    }

    @Test
    public void testRepeatedListEmptyLast() throws Exception {
        String query = "select * from cp.`vector/complex/repeated-list-empty-last.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/repeated-list-empty-last.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(TestBuilder.listOf(1L))).baselineValues(TestBuilder.listOf(TestBuilder.listOf(2L))).baselineValues(TestBuilder.listOf(new Object[0])).go();
    }

    @Test
    public void testRepeatedListEmptyBetween() throws Exception {
        String query = "select * from cp.`vector/complex/repeated-list-empty-between.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/repeated-list-empty-between.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(TestBuilder.listOf(1L))).baselineValues(TestBuilder.listOf(new Object[0])).baselineValues(TestBuilder.listOf(TestBuilder.listOf(2L))).go();
    }

    @Test
    public void testRepeatedMapEmptyFirst() throws Exception {
        String query = "select * from cp.`vector/complex/repeated-map-empty-first.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/repeated-map-empty-first.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(new Object[0])).baselineValues(TestBuilder.listOf(TestBuilder.mapOf("b", 1L))).baselineValues(TestBuilder.listOf(TestBuilder.mapOf("b", 2L))).go();
    }

    @Test
    public void testRepeatedMapEmptyLast() throws Exception {
        String query = "select * from cp.`vector/complex/repeated-map-empty-last.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/repeated-map-empty-last.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(TestBuilder.mapOf("b", 1L))).baselineValues(TestBuilder.listOf(TestBuilder.mapOf("b", 2L))).baselineValues(TestBuilder.listOf(new Object[0])).go();
    }

    @Test
    public void testRepeatedMapEmptyBetween() throws Exception {
        String query = "select * from cp.`vector/complex/repeated-map-empty-between.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/repeated-map-empty-between.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(TestBuilder.mapOf("b", 1L))).baselineValues(TestBuilder.listOf(new Object[0])).baselineValues(TestBuilder.listOf(TestBuilder.mapOf("b", 2L))).go();
    }

    @Test
    public void testMapEmptyFirst() throws Exception {
        String query = "select * from cp.`vector/complex/map-empty-first.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/map-empty-first.json`").ordered().baselineColumns("a", "c").baselineValues(TestBuilder.mapOf(new Object[0]), 1L).baselineValues(TestBuilder.mapOf("b", 1L), null).baselineValues(TestBuilder.mapOf("b", 2L), null).go();
    }

    @Test
    public void testMapEmptyLast() throws Exception {
        String query = "select * from cp.`vector/complex/map-empty-last.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/map-empty-last.json`").ordered().baselineColumns("a", "c").baselineValues(TestBuilder.mapOf("b", 1L), null).baselineValues(TestBuilder.mapOf("b", 2L), null).baselineValues(TestBuilder.mapOf(new Object[0]), 1L).go();
    }

    @Test
    public void testMapEmptyBetween() throws Exception {
        String query = "select * from cp.`vector/complex/map-empty-between.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/map-empty-between.json`").ordered().baselineColumns("a", "c").baselineValues(TestBuilder.mapOf("b", 1L), null).baselineValues(TestBuilder.mapOf(new Object[0]), 1L).baselineValues(TestBuilder.mapOf("b", 2L), null).go();
    }

    @Test
    public void testMultiLevelRepeatedListEmptyFirst() throws Exception {
        String query = "select * from cp.`vector/complex/multi-repeated-list-empty-first.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/multi-repeated-list-empty-first.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(new Object[0])).baselineValues(TestBuilder.listOf(TestBuilder.listOf(TestBuilder.listOf(1L), TestBuilder.listOf(3L)), TestBuilder.listOf(TestBuilder.listOf(5L, 7L)))).baselineValues(TestBuilder.listOf(TestBuilder.listOf(TestBuilder.listOf(2L), TestBuilder.listOf(4L)))).go();
    }

    @Test
    public void testMultiLevelRepeatedListEmptyLast() throws Exception {
        String query = "select * from cp.`vector/complex/multi-repeated-list-empty-last.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/multi-repeated-list-empty-last.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(TestBuilder.listOf(TestBuilder.listOf(1L), TestBuilder.listOf(3L)), TestBuilder.listOf(TestBuilder.listOf(5L, 7L)))).baselineValues(TestBuilder.listOf(TestBuilder.listOf(TestBuilder.listOf(2L), TestBuilder.listOf(4L)))).baselineValues(TestBuilder.listOf(new Object[0])).go();
    }

    @Test
    public void testMultiLevelRepeatedListEmptyBetween() throws Exception {
        String query = "select * from cp.`vector/complex/multi-repeated-list-empty-between.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/multi-repeated-list-empty-between.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(TestBuilder.listOf(TestBuilder.listOf(1L), TestBuilder.listOf(3L)), TestBuilder.listOf(TestBuilder.listOf(5L, 7L)))).baselineValues(TestBuilder.listOf(new Object[0])).baselineValues(TestBuilder.listOf(TestBuilder.listOf(TestBuilder.listOf(2L), TestBuilder.listOf(4L)))).go();
    }

    @Test
    public void testMultiLevelRepeatedListWithMultipleEmpties() throws Exception {
        String query = "select * from cp.`vector/complex/multi-repeated-list-multi-empty.json`";
        TestEmptyPopulation.testBuilder().sqlQuery("select * from cp.`vector/complex/multi-repeated-list-multi-empty.json`").ordered().baselineColumns("a").baselineValues(TestBuilder.listOf(new Object[0])).baselineValues(TestBuilder.listOf(TestBuilder.listOf(TestBuilder.listOf(1L), TestBuilder.listOf(3L)), TestBuilder.listOf(TestBuilder.listOf(new Object[0])))).baselineValues(TestBuilder.listOf(TestBuilder.listOf(TestBuilder.listOf(2L), TestBuilder.listOf(new Object[0])), TestBuilder.listOf(new Object[0]))).go();
    }
}

