/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;

public class VarCharAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.required((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR);
    private final VarCharVector.Accessor ac;

    public VarCharAccessor(VarCharVector vector) {
        this.ac = vector.getAccessor();
    }

    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    public boolean isNull(int index) {
        return false;
    }

    public InputStream getStream(int index) {
        VarCharHolder h = new VarCharHolder();
        this.ac.get(index, h);
        return new ByteBufInputStream((ByteBuf)h.buffer.slice(h.start, h.end));
    }

    public byte[] getBytes(int index) {
        return this.ac.get(index);
    }

    public Class<?> getObjectClass() {
        return String.class;
    }

    public String getObject(int index) {
        return this.getString(index);
    }

    public InputStreamReader getReader(int index) {
        return new InputStreamReader(this.getStream(index), Charsets.UTF_8);
    }

    public String getString(int index) {
        return new String(this.getBytes(index), Charsets.UTF_8);
    }
}

