/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import java.sql.Timestamp;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.TimeStampVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimeStampAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.required((TypeProtos.MinorType)TypeProtos.MinorType.TIMESTAMP);
    private final TimeStampVector.Accessor ac;

    public TimeStampAccessor(TimeStampVector vector) {
        this.ac = vector.getAccessor();
    }

    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    public boolean isNull(int index) {
        return false;
    }

    public Class<?> getObjectClass() {
        return Timestamp.class;
    }

    public Object getObject(int index) {
        return this.getTimestamp(index);
    }

    public Timestamp getTimestamp(int index) {
        DateTime date = new DateTime(this.ac.get(index), DateTimeZone.UTC);
        date = date.withZoneRetainFields(DateTimeZone.getDefault());
        return new Timestamp(date.getMillis());
    }
}

