/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;

public class NullableVarBinaryAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARBINARY);
    private final NullableVarBinaryVector.Accessor ac;

    public NullableVarBinaryAccessor(NullableVarBinaryVector vector) {
        this.ac = vector.getAccessor();
    }

    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    public Class<?> getObjectClass() {
        return byte[].class;
    }

    public Object getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.getObject(index);
    }

    public InputStream getStream(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        NullableVarBinaryHolder h = new NullableVarBinaryHolder();
        this.ac.get(index, h);
        return new ByteBufInputStream((ByteBuf)h.buffer.slice(h.start, h.end));
    }

    public byte[] getBytes(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.get(index);
    }

    public String getString(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        byte[] b = this.ac.get(index);
        return DrillStringUtils.toBinaryString((byte[])b);
    }
}

