/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.vector.NullableVar16CharVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;

public class NullableVar16CharAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VAR16CHAR);
    private final NullableVar16CharVector.Accessor ac;

    public NullableVar16CharAccessor(NullableVar16CharVector vector) {
        this.ac = vector.getAccessor();
    }

    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    public Class<?> getObjectClass() {
        return String.class;
    }

    public Object getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.getObject(index);
    }

    public InputStream getStream(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        NullableVar16CharHolder h = new NullableVar16CharHolder();
        this.ac.get(index, h);
        return new ByteBufInputStream((ByteBuf)h.buffer.slice(h.start, h.end));
    }

    public byte[] getBytes(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.get(index);
    }

    public InputStreamReader getReader(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return new InputStreamReader(this.getStream(index), Charsets.UTF_16);
    }

    public String getString(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return new String(this.getBytes(index), Charsets.UTF_16);
    }
}

