/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import java.sql.Timestamp;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class NullableTimeStampAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.TIMESTAMP);
    private final NullableTimeStampVector.Accessor ac;

    public NullableTimeStampAccessor(NullableTimeStampVector vector) {
        this.ac = vector.getAccessor();
    }

    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    public Class<?> getObjectClass() {
        return Timestamp.class;
    }

    public Object getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.getTimestamp(index);
    }

    public Timestamp getTimestamp(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        DateTime date = new DateTime(this.ac.get(index), DateTimeZone.UTC);
        date = date.withZoneRetainFields(DateTimeZone.getDefault());
        return new Timestamp(date.getMillis());
    }
}

