/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import java.sql.Time;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.NullableTimeVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class NullableTimeAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.TIME);
    private final NullableTimeVector.Accessor ac;

    public NullableTimeAccessor(NullableTimeVector vector) {
        this.ac = vector.getAccessor();
    }

    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    public Class<?> getObjectClass() {
        return Time.class;
    }

    public Object getObject(int index) {
        return this.getTime(index);
    }

    public Time getTime(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        DateTime time = new DateTime((long)this.ac.get(index), DateTimeZone.UTC);
        time = time.withZoneRetainFields(DateTimeZone.getDefault());
        return new TimePrintMillis(time.getMillis());
    }
}

