/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.NullableIntervalVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import org.joda.time.Period;

public class NullableIntervalAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.INTERVAL);
    private final NullableIntervalVector.Accessor ac;

    public NullableIntervalAccessor(NullableIntervalVector vector) {
        this.ac = vector.getAccessor();
    }

    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    public Class<?> getObjectClass() {
        return Period.class;
    }

    public Object getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.getObject(index);
    }

    public String getString(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return String.valueOf(this.ac.getAsStringBuilder(index));
    }
}

