/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;

public class NullableBitAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.BIT);
    private final NullableBitVector.Accessor ac;

    public NullableBitAccessor(NullableBitVector vector) {
        this.ac = vector.getAccessor();
    }

    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    public Class<?> getObjectClass() {
        return Boolean.class;
    }

    public Object getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.getObject(index);
    }

    public int getInt(int index) {
        return this.ac.get(index);
    }

    public boolean getBoolean(int index) {
        if (this.ac.isNull(index)) {
            return false;
        }
        return 1 == this.ac.get(index);
    }
}

