/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.GenericAccessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class GenericAccessorTest {
    public static final Object NON_NULL_VALUE = "Non-null value";
    private GenericAccessor genericAccessor;
    private ValueVector valueVector;
    private ValueVector.Accessor accessor;
    private UserBitShared.SerializedField metadata;

    @Before
    public void setUp() throws Exception {
        this.accessor = (ValueVector.Accessor)Mockito.mock(ValueVector.Accessor.class);
        Mockito.when((Object)this.accessor.getObject(Matchers.anyInt())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] args = invocationOnMock.getArguments();
                Integer index = (Integer)args[0];
                if (index == 0) {
                    return NON_NULL_VALUE;
                }
                if (index == 1) {
                    return null;
                }
                throw new IndexOutOfBoundsException("Index out of bounds");
            }
        });
        Mockito.when((Object)this.accessor.isNull(Matchers.anyInt())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] args = invocationOnMock.getArguments();
                Integer index = (Integer)args[0];
                if (index == 0) {
                    return false;
                }
                return true;
            }
        });
        this.metadata = UserBitShared.SerializedField.getDefaultInstance();
        this.valueVector = (ValueVector)Mockito.mock(ValueVector.class);
        Mockito.when((Object)this.valueVector.getAccessor()).thenReturn((Object)this.accessor);
        Mockito.when((Object)this.valueVector.getMetadata()).thenReturn((Object)this.metadata);
        this.genericAccessor = new GenericAccessor(this.valueVector);
    }

    @Test
    public void testIsNull() throws Exception {
        Assert.assertFalse((boolean)this.genericAccessor.isNull(0));
        Assert.assertTrue((boolean)this.genericAccessor.isNull(1));
    }

    @Test
    public void testGetObject() throws Exception {
        Assert.assertEquals((Object)NON_NULL_VALUE, (Object)this.genericAccessor.getObject(0));
        Assert.assertNull((Object)this.genericAccessor.getObject(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetObject_indexOutOfBounds() throws Exception {
        this.genericAccessor.getObject(2);
    }

    @Test
    public void testGetType() throws Exception {
        Assert.assertEquals((Object)UserBitShared.SerializedField.getDefaultInstance().getMajorType(), (Object)this.genericAccessor.getType());
    }
}

