/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;

public class BitAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.required((TypeProtos.MinorType)TypeProtos.MinorType.BIT);
    private final BitVector.Accessor ac;

    public BitAccessor(BitVector vector) {
        this.ac = vector.getAccessor();
    }

    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    public boolean isNull(int index) {
        return false;
    }

    public Class<?> getObjectClass() {
        return Boolean.class;
    }

    public Object getObject(int index) {
        return this.ac.getObject(index);
    }

    public int getInt(int index) {
        return this.ac.get(index);
    }

    public boolean getBoolean(int index) {
        return 1 == this.ac.get(index);
    }
}

