/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.junit.Assert;
import org.junit.Test;

public class TestSplitAndTransfer {
    @Test
    public void test() throws Exception {
        int[][] startLengths;
        DrillConfig drillConfig = DrillConfig.create();
        BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)drillConfig);
        MaterializedField field = MaterializedField.create((String)"field", (TypeProtos.MajorType)Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        NullableVarCharVector varCharVector = new NullableVarCharVector(field, allocator);
        varCharVector.allocateNew(10000, 1000);
        String[] compareArray = new String[500];
        for (int i = 0; i < 500; i += 3) {
            String s = String.format("%010d", i);
            varCharVector.getMutator().set(i, s.getBytes());
            compareArray[i] = s;
        }
        varCharVector.getMutator().setValueCount(500);
        TransferPair tp = varCharVector.getTransferPair();
        NullableVarCharVector newVarCharVector = (NullableVarCharVector)tp.getTo();
        NullableVarCharVector.Accessor accessor = newVarCharVector.getAccessor();
        for (int[] startLength : startLengths = new int[][]{{0, 201}, {201, 200}, {401, 99}}) {
            int start = startLength[0];
            int length = startLength[1];
            tp.splitAndTransfer(start, length);
            newVarCharVector.getMutator().setValueCount(length);
            for (int i = 0; i < length; ++i) {
                boolean expectedSet;
                boolean bl = expectedSet = (start + i) % 3 == 0;
                if (expectedSet) {
                    byte[] expectedValue = compareArray[start + i].getBytes();
                    Assert.assertFalse((boolean)accessor.isNull(i));
                    Assert.assertArrayEquals((byte[])expectedValue, (byte[])accessor.get(i));
                    continue;
                }
                Assert.assertTrue((boolean)accessor.isNull(i));
            }
            newVarCharVector.clear();
        }
        varCharVector.clear();
        allocator.close();
    }
}

