/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.RepeatedVar16CharHolder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.AddOrGetResult;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.Var16CharVector;
import org.apache.drill.exec.vector.VectorDescriptor;
import org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.exec.vector.complex.RepeatedVariableWidthVectorLike;
import org.apache.drill.exec.vector.complex.impl.RepeatedVar16CharReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedVar16CharVector
extends BaseRepeatedValueVector
implements RepeatedVariableWidthVectorLike {
    private Var16CharVector values;
    private final FieldReader reader = new RepeatedVar16CharReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedVar16CharVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.addOrGetVector(VectorDescriptor.create((TypeProtos.MajorType)Types.required((TypeProtos.MinorType)field.getType().getMinorType())));
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public FieldReader getReader() {
        return this.reader;
    }

    public Var16CharVector getDataVector() {
        return this.values;
    }

    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath((SchemaPath)ref));
    }

    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedVar16CharVector)to);
    }

    public AddOrGetResult<Var16CharVector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = (Var16CharVector)result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedVar16CharVector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedVar16CharVector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedVar16CharVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedVar16CharVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryRuntimeException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    protected UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().setVarByteLength(this.values.getVarByteLength());
    }

    public void allocateNew(int totalBytes, int valueCount, int innerValueCount) {
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(totalBytes, innerValueCount);
        }
        catch (OutOfMemoryRuntimeException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public int getByteCapacity() {
        return this.values.getByteCapacity();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
            super((BaseRepeatedValueVector)RepeatedVar16CharVector.this);
        }

        public void add(int index, byte[] value) {
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().set(nextOffset, value);
            RepeatedVar16CharVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, byte[] bytes) {
            this.addSafe(index, bytes, 0, bytes.length);
        }

        public void addSafe(int index, byte[] bytes, int start, int length) {
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().setSafe(nextOffset, bytes, start, length);
            RepeatedVar16CharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedVar16CharHolder h) {
            Var16CharHolder ih = new Var16CharHolder();
            Var16CharVector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedVar16CharVector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedVar16CharVector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, Var16CharHolder holder) {
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedVar16CharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableVar16CharHolder holder) {
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedVar16CharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int arrayIndex, int start, int end, DrillBuf buffer) {
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(arrayIndex + 1);
            RepeatedVar16CharVector.this.values.getMutator().setSafe(nextOffset, start, end, buffer);
            RepeatedVar16CharVector.this.offsets.getMutator().setSafe(arrayIndex + 1, nextOffset + 1);
        }

        protected void add(int index, Var16CharHolder holder) {
            int nextOffset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVar16CharVector.this.values.getMutator().set(nextOffset, holder);
            RepeatedVar16CharVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedVar16CharHolder holder) {
            Var16CharVector.Accessor accessor = holder.vector.getAccessor();
            Var16CharHolder innerHolder = new Var16CharHolder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedVar16CharVector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedVar16CharVector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        public Accessor() {
            super((BaseRepeatedValueVector)RepeatedVar16CharVector.this);
        }

        public List<String> getObject(int index) {
            JsonStringArrayList vals = new JsonStringArrayList();
            UInt4Vector.Accessor offsetsAccessor = RepeatedVar16CharVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            Var16CharVector.Accessor valuesAccessor = RepeatedVar16CharVector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public String getSingleObject(int index, int arrayIndex) {
            int start = RepeatedVar16CharVector.this.offsets.getAccessor().get(index);
            return RepeatedVar16CharVector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public byte[] get(int index, int positionIndex) {
            return RepeatedVar16CharVector.this.values.getAccessor().get(RepeatedVar16CharVector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedVar16CharHolder holder) {
            holder.start = RepeatedVar16CharVector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedVar16CharVector.this.values;
        }

        public void get(int index, int positionIndex, Var16CharHolder holder) {
            int offset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedVar16CharVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableVar16CharHolder holder) {
            int offset = RepeatedVar16CharVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedVar16CharVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedVar16CharVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new RepeatedVar16CharVector(field, RepeatedVar16CharVector.this.allocator);
        }

        public TransferImpl(RepeatedVar16CharVector to) {
            this.to = to;
        }

        public RepeatedVar16CharVector getTo() {
            return this.to;
        }

        public void transfer() {
            RepeatedVar16CharVector.this.transferTo(this.to);
        }

        public void splitAndTransfer(int startIndex, int length) {
            RepeatedVar16CharVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedVar16CharVector.this);
        }
    }
}

