/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.RepeatedUInt1Holder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.AddOrGetResult;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorDescriptor;
import org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.exec.vector.complex.impl.RepeatedUInt1ReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedUInt1Vector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private UInt1Vector values;
    private final FieldReader reader = new RepeatedUInt1ReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedUInt1Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.addOrGetVector(VectorDescriptor.create((TypeProtos.MajorType)Types.required((TypeProtos.MinorType)field.getType().getMinorType())));
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public FieldReader getReader() {
        return this.reader;
    }

    public UInt1Vector getDataVector() {
        return this.values;
    }

    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath((SchemaPath)ref));
    }

    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedUInt1Vector)to);
    }

    public AddOrGetResult<UInt1Vector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = (UInt1Vector)result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedUInt1Vector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedUInt1Vector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedUInt1Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedUInt1Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryRuntimeException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        boolean success = false;
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryRuntimeException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
            super((BaseRepeatedValueVector)RepeatedUInt1Vector.this);
        }

        public void add(int index, int value) {
            int nextOffset = RepeatedUInt1Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt1Vector.this.values.getMutator().set(nextOffset, value);
            RepeatedUInt1Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, byte srcValue) {
            int nextOffset = RepeatedUInt1Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt1Vector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedUInt1Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedUInt1Holder h) {
            UInt1Holder ih = new UInt1Holder();
            UInt1Vector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedUInt1Vector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedUInt1Vector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, UInt1Holder holder) {
            int nextOffset = RepeatedUInt1Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt1Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedUInt1Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableUInt1Holder holder) {
            int nextOffset = RepeatedUInt1Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt1Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedUInt1Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        protected void add(int index, UInt1Holder holder) {
            int nextOffset = RepeatedUInt1Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedUInt1Vector.this.values.getMutator().set(nextOffset, holder);
            RepeatedUInt1Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedUInt1Holder holder) {
            UInt1Vector.Accessor accessor = holder.vector.getAccessor();
            UInt1Holder innerHolder = new UInt1Holder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedUInt1Vector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedUInt1Vector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        public Accessor() {
            super((BaseRepeatedValueVector)RepeatedUInt1Vector.this);
        }

        public List<Byte> getObject(int index) {
            JsonStringArrayList vals = new JsonStringArrayList();
            UInt4Vector.Accessor offsetsAccessor = RepeatedUInt1Vector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            UInt1Vector.Accessor valuesAccessor = RepeatedUInt1Vector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public Byte getSingleObject(int index, int arrayIndex) {
            int start = RepeatedUInt1Vector.this.offsets.getAccessor().get(index);
            return RepeatedUInt1Vector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public byte get(int index, int positionIndex) {
            return RepeatedUInt1Vector.this.values.getAccessor().get(RepeatedUInt1Vector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedUInt1Holder holder) {
            holder.start = RepeatedUInt1Vector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedUInt1Vector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedUInt1Vector.this.values;
        }

        public void get(int index, int positionIndex, UInt1Holder holder) {
            int offset = RepeatedUInt1Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedUInt1Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableUInt1Holder holder) {
            int offset = RepeatedUInt1Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedUInt1Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedUInt1Vector to;

        public TransferImpl(MaterializedField field) {
            this.to = new RepeatedUInt1Vector(field, RepeatedUInt1Vector.this.allocator);
        }

        public TransferImpl(RepeatedUInt1Vector to) {
            this.to = to;
        }

        public RepeatedUInt1Vector getTo() {
            return this.to;
        }

        public void transfer() {
            RepeatedUInt1Vector.this.transferTo(this.to);
        }

        public void splitAndTransfer(int startIndex, int length) {
            RepeatedUInt1Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedUInt1Vector.this);
        }
    }
}

