/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.RepeatedFloat4Holder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.AddOrGetResult;
import org.apache.drill.exec.vector.Float4Vector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorDescriptor;
import org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.exec.vector.complex.impl.RepeatedFloat4ReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedFloat4Vector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private Float4Vector values;
    private final FieldReader reader = new RepeatedFloat4ReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedFloat4Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.addOrGetVector(VectorDescriptor.create((TypeProtos.MajorType)Types.required((TypeProtos.MinorType)field.getType().getMinorType())));
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public FieldReader getReader() {
        return this.reader;
    }

    public Float4Vector getDataVector() {
        return this.values;
    }

    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath((SchemaPath)ref));
    }

    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedFloat4Vector)to);
    }

    public AddOrGetResult<Float4Vector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = (Float4Vector)result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedFloat4Vector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedFloat4Vector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedFloat4Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedFloat4Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryRuntimeException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        boolean success = false;
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryRuntimeException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
            super((BaseRepeatedValueVector)RepeatedFloat4Vector.this);
        }

        public void add(int index, float value) {
            int nextOffset = RepeatedFloat4Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedFloat4Vector.this.values.getMutator().set(nextOffset, value);
            RepeatedFloat4Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, float srcValue) {
            int nextOffset = RepeatedFloat4Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedFloat4Vector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedFloat4Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedFloat4Holder h) {
            Float4Holder ih = new Float4Holder();
            Float4Vector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedFloat4Vector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedFloat4Vector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, Float4Holder holder) {
            int nextOffset = RepeatedFloat4Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedFloat4Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedFloat4Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableFloat4Holder holder) {
            int nextOffset = RepeatedFloat4Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedFloat4Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedFloat4Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        protected void add(int index, Float4Holder holder) {
            int nextOffset = RepeatedFloat4Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedFloat4Vector.this.values.getMutator().set(nextOffset, holder);
            RepeatedFloat4Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedFloat4Holder holder) {
            Float4Vector.Accessor accessor = holder.vector.getAccessor();
            Float4Holder innerHolder = new Float4Holder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedFloat4Vector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedFloat4Vector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        public Accessor() {
            super((BaseRepeatedValueVector)RepeatedFloat4Vector.this);
        }

        public List<Float> getObject(int index) {
            JsonStringArrayList vals = new JsonStringArrayList();
            UInt4Vector.Accessor offsetsAccessor = RepeatedFloat4Vector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            Float4Vector.Accessor valuesAccessor = RepeatedFloat4Vector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public Float getSingleObject(int index, int arrayIndex) {
            int start = RepeatedFloat4Vector.this.offsets.getAccessor().get(index);
            return RepeatedFloat4Vector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public float get(int index, int positionIndex) {
            return RepeatedFloat4Vector.this.values.getAccessor().get(RepeatedFloat4Vector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedFloat4Holder holder) {
            holder.start = RepeatedFloat4Vector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedFloat4Vector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedFloat4Vector.this.values;
        }

        public void get(int index, int positionIndex, Float4Holder holder) {
            int offset = RepeatedFloat4Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedFloat4Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableFloat4Holder holder) {
            int offset = RepeatedFloat4Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedFloat4Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedFloat4Vector to;

        public TransferImpl(MaterializedField field) {
            this.to = new RepeatedFloat4Vector(field, RepeatedFloat4Vector.this.allocator);
        }

        public TransferImpl(RepeatedFloat4Vector to) {
            this.to = to;
        }

        public RepeatedFloat4Vector getTo() {
            return this.to;
        }

        public void transfer() {
            RepeatedFloat4Vector.this.transferTo(this.to);
        }

        public void splitAndTransfer(int startIndex, int length) {
            RepeatedFloat4Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedFloat4Vector.this);
        }
    }
}

