/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import java.math.BigDecimal;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal9Holder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.AddOrGetResult;
import org.apache.drill.exec.vector.Decimal9Vector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorDescriptor;
import org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.exec.vector.complex.impl.RepeatedDecimal9ReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedDecimal9Vector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private Decimal9Vector values;
    private final FieldReader reader = new RepeatedDecimal9ReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedDecimal9Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.addOrGetVector(VectorDescriptor.create((TypeProtos.MajorType)Types.required((TypeProtos.MinorType)field.getType().getMinorType())));
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public FieldReader getReader() {
        return this.reader;
    }

    public Decimal9Vector getDataVector() {
        return this.values;
    }

    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath((SchemaPath)ref));
    }

    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedDecimal9Vector)to);
    }

    public AddOrGetResult<Decimal9Vector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = (Decimal9Vector)result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedDecimal9Vector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedDecimal9Vector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedDecimal9Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedDecimal9Vector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryRuntimeException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        boolean success = false;
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryRuntimeException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
            super((BaseRepeatedValueVector)RepeatedDecimal9Vector.this);
        }

        public void add(int index, int value) {
            int nextOffset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal9Vector.this.values.getMutator().set(nextOffset, value);
            RepeatedDecimal9Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, int srcValue) {
            int nextOffset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal9Vector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedDecimal9Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedDecimal9Holder h) {
            Decimal9Holder ih = new Decimal9Holder();
            Decimal9Vector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedDecimal9Vector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedDecimal9Vector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, Decimal9Holder holder) {
            int nextOffset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal9Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedDecimal9Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableDecimal9Holder holder) {
            int nextOffset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal9Vector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedDecimal9Vector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        protected void add(int index, Decimal9Holder holder) {
            int nextOffset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index + 1);
            RepeatedDecimal9Vector.this.values.getMutator().set(nextOffset, holder);
            RepeatedDecimal9Vector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedDecimal9Holder holder) {
            Decimal9Vector.Accessor accessor = holder.vector.getAccessor();
            Decimal9Holder innerHolder = new Decimal9Holder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedDecimal9Vector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedDecimal9Vector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        public Accessor() {
            super((BaseRepeatedValueVector)RepeatedDecimal9Vector.this);
        }

        public List<BigDecimal> getObject(int index) {
            JsonStringArrayList vals = new JsonStringArrayList();
            UInt4Vector.Accessor offsetsAccessor = RepeatedDecimal9Vector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            Decimal9Vector.Accessor valuesAccessor = RepeatedDecimal9Vector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public BigDecimal getSingleObject(int index, int arrayIndex) {
            int start = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index);
            return RepeatedDecimal9Vector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public int get(int index, int positionIndex) {
            return RepeatedDecimal9Vector.this.values.getAccessor().get(RepeatedDecimal9Vector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedDecimal9Holder holder) {
            holder.start = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedDecimal9Vector.this.values;
        }

        public void get(int index, int positionIndex, Decimal9Holder holder) {
            int offset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedDecimal9Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableDecimal9Holder holder) {
            int offset = RepeatedDecimal9Vector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedDecimal9Vector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedDecimal9Vector to;

        public TransferImpl(MaterializedField field) {
            this.to = new RepeatedDecimal9Vector(field, RepeatedDecimal9Vector.this.allocator);
        }

        public TransferImpl(RepeatedDecimal9Vector to) {
            this.to = to;
        }

        public RepeatedDecimal9Vector getTo() {
            return this.to;
        }

        public void transfer() {
            RepeatedDecimal9Vector.this.transferTo(this.to);
        }

        public void splitAndTransfer(int startIndex, int length) {
            RepeatedDecimal9Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedDecimal9Vector.this);
        }
    }
}

