/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import java.nio.ByteBuffer;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.NullableVectorDefinitionSetter;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.apache.drill.exec.vector.complex.impl.NullableVarBinaryReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NullableVarBinaryVector
extends BaseDataValueVector
implements VariableWidthVector,
NullableVector {
    private static final Logger logger = LoggerFactory.getLogger(NullableVarBinaryVector.class);
    private final FieldReader reader = new NullableVarBinaryReaderImpl(this);
    private final MaterializedField bitsField = MaterializedField.create((String)"$bits$", (TypeProtos.MajorType)Types.required((TypeProtos.MinorType)TypeProtos.MinorType.UINT1));
    private final UInt1Vector bits = new UInt1Vector(this.bitsField, this.allocator);
    private final VarBinaryVector values = new VarBinaryVector(this.field, this.allocator);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public NullableVarBinaryVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public FieldReader getReader() {
        return this.reader;
    }

    public int getValueCapacity() {
        return Math.min(this.bits.getValueCapacity(), this.values.getValueCapacity());
    }

    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = (DrillBuf[])ObjectArrays.concat((Object[])this.bits.getBuffers(false), (Object[])this.values.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    public void close() {
        this.bits.close();
        this.values.close();
        super.close();
    }

    public void clear() {
        this.bits.clear();
        this.values.clear();
        super.clear();
    }

    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.values.getBufferSizeFor(valueCount) + this.bits.getBufferSizeFor(valueCount);
    }

    public DrillBuf getBuffer() {
        return this.values.getBuffer();
    }

    public VarBinaryVector getValuesVector() {
        return this.values;
    }

    public void setInitialCapacity(int numRecords) {
        this.bits.setInitialCapacity(numRecords);
        this.values.setInitialCapacity(numRecords);
    }

    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.bits.getMetadata()).addChild(this.values.getMetadata());
    }

    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            success = this.values.allocateNewSafe() && this.bits.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return success;
    }

    public void allocateNew(int totalBytes, int valueCount) {
        try {
            this.values.allocateNew(totalBytes, valueCount);
            this.bits.allocateNew(valueCount);
        }
        catch (DrillRuntimeException e) {
            this.clear();
            throw e;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    public void reset() {
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        super.reset();
    }

    public int getByteCapacity() {
        return this.values.getByteCapacity();
    }

    public int getCurrentSizeInBytes() {
        return this.values.getCurrentSizeInBytes();
    }

    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        this.bits.load(bitsField, buffer);
        int capacity = buffer.capacity();
        int bitsLength = bitsField.getBufferLength();
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        this.values.load(valuesField, buffer.slice(bitsLength, capacity - bitsLength));
    }

    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath((SchemaPath)ref));
    }

    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableVarBinaryVector)to);
    }

    public void transferTo(NullableVarBinaryVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        target.mutator.lastSet = this.mutator.lastSet;
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, NullableVarBinaryVector target) {
        this.bits.splitAndTransferTo(startIndex, length, target.bits);
        this.values.splitAndTransferTo(startIndex, length, target.values);
        target.mutator.lastSet = length - 1;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public VarBinaryVector convertToRequiredVector() {
        VarBinaryVector v = new VarBinaryVector(this.getField().getOtherNullableVersion(), this.allocator);
        if (v.data != null) {
            v.data.release(1);
        }
        v.data = this.values.data;
        v.data.retain(1);
        this.clear();
        return v;
    }

    public void copyFrom(int fromIndex, int thisIndex, NullableVarBinaryVector from) {
        Accessor fromAccessor = from.getAccessor();
        if (!fromAccessor.isNull(fromIndex)) {
            this.mutator.set(thisIndex, fromAccessor.get(fromIndex));
        }
    }

    public void copyFromSafe(int fromIndex, int thisIndex, VarBinaryVector from) {
        this.mutator.fillEmpties(thisIndex);
        this.values.copyFromSafe(fromIndex, thisIndex, from);
        this.bits.getMutator().setSafe(thisIndex, 1);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, NullableVarBinaryVector from) {
        this.mutator.fillEmpties(thisIndex);
        this.bits.copyFromSafe(fromIndex, thisIndex, from.bits);
        this.values.copyFromSafe(fromIndex, thisIndex, from.values);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements NullableVectorDefinitionSetter,
    VariableWidthVector.VariableWidthMutator {
        private int setCount;
        private int lastSet = -1;

        private Mutator() {
        }

        public VarBinaryVector getVectorWithValues() {
            return NullableVarBinaryVector.this.values;
        }

        public void setIndexDefined(int index) {
            NullableVarBinaryVector.this.bits.getMutator().set(index, 1);
        }

        public void set(int index, byte[] value) {
            ++this.setCount;
            VarBinaryVector.Mutator valuesMutator = NullableVarBinaryVector.this.values.getMutator();
            UInt1Vector.Mutator bitsMutator = NullableVarBinaryVector.this.bits.getMutator();
            for (int i = this.lastSet + 1; i < index; ++i) {
                valuesMutator.set(i, BaseDataValueVector.emptyByteArray);
            }
            bitsMutator.set(index, 1);
            valuesMutator.set(index, value);
            this.lastSet = index;
        }

        private void fillEmpties(int index) {
            VarBinaryVector.Mutator valuesMutator = NullableVarBinaryVector.this.values.getMutator();
            for (int i = this.lastSet; i < index; ++i) {
                valuesMutator.setSafe(i + 1, BaseDataValueVector.emptyByteArray);
            }
            while (index > NullableVarBinaryVector.this.bits.getValueCapacity()) {
                NullableVarBinaryVector.this.bits.reAlloc();
            }
            this.lastSet = index;
        }

        public void setValueLengthSafe(int index, int length) {
            NullableVarBinaryVector.this.values.getMutator().setValueLengthSafe(index, length);
            this.lastSet = index;
        }

        public void setSafe(int index, byte[] value, int start, int length) {
            this.fillEmpties(index);
            NullableVarBinaryVector.this.bits.getMutator().setSafe(index, 1);
            NullableVarBinaryVector.this.values.getMutator().setSafe(index, value, start, length);
            ++this.setCount;
            this.lastSet = index;
        }

        public void setSafe(int index, ByteBuffer value, int start, int length) {
            this.fillEmpties(index);
            NullableVarBinaryVector.this.bits.getMutator().setSafe(index, 1);
            NullableVarBinaryVector.this.values.getMutator().setSafe(index, value, start, length);
            ++this.setCount;
            this.lastSet = index;
        }

        public void setNull(int index) {
            NullableVarBinaryVector.this.bits.getMutator().setSafe(index, 0);
        }

        public void setSkipNull(int index, VarBinaryHolder holder) {
            NullableVarBinaryVector.this.values.getMutator().set(index, holder);
        }

        public void setSkipNull(int index, NullableVarBinaryHolder holder) {
            NullableVarBinaryVector.this.values.getMutator().set(index, holder);
        }

        public void set(int index, NullableVarBinaryHolder holder) {
            VarBinaryVector.Mutator valuesMutator = NullableVarBinaryVector.this.values.getMutator();
            for (int i = this.lastSet + 1; i < index; ++i) {
                valuesMutator.set(i, BaseDataValueVector.emptyByteArray);
            }
            NullableVarBinaryVector.this.bits.getMutator().set(index, holder.isSet);
            valuesMutator.set(index, holder);
            this.lastSet = index;
        }

        public void set(int index, VarBinaryHolder holder) {
            VarBinaryVector.Mutator valuesMutator = NullableVarBinaryVector.this.values.getMutator();
            for (int i = this.lastSet + 1; i < index; ++i) {
                valuesMutator.set(i, BaseDataValueVector.emptyByteArray);
            }
            NullableVarBinaryVector.this.bits.getMutator().set(index, 1);
            valuesMutator.set(index, holder);
            this.lastSet = index;
        }

        public boolean isSafe(int outIndex) {
            return outIndex < NullableVarBinaryVector.this.getValueCapacity();
        }

        public void set(int index, int isSet, int startField, int endField, DrillBuf bufferField) {
            VarBinaryVector.Mutator valuesMutator = NullableVarBinaryVector.this.values.getMutator();
            for (int i = this.lastSet + 1; i < index; ++i) {
                valuesMutator.set(i, BaseDataValueVector.emptyByteArray);
            }
            NullableVarBinaryVector.this.bits.getMutator().set(index, isSet);
            valuesMutator.set(index, startField, endField, bufferField);
            this.lastSet = index;
        }

        public void setSafe(int index, int isSet, int startField, int endField, DrillBuf bufferField) {
            this.fillEmpties(index);
            NullableVarBinaryVector.this.bits.getMutator().setSafe(index, isSet);
            NullableVarBinaryVector.this.values.getMutator().setSafe(index, startField, endField, bufferField);
            ++this.setCount;
            this.lastSet = index;
        }

        public void setSafe(int index, NullableVarBinaryHolder value) {
            this.fillEmpties(index);
            NullableVarBinaryVector.this.bits.getMutator().setSafe(index, value.isSet);
            NullableVarBinaryVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
            this.lastSet = index;
        }

        public void setSafe(int index, VarBinaryHolder value) {
            this.fillEmpties(index);
            NullableVarBinaryVector.this.bits.getMutator().setSafe(index, 1);
            NullableVarBinaryVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
            this.lastSet = index;
        }

        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            this.fillEmpties(valueCount);
            NullableVarBinaryVector.this.values.getMutator().setValueCount(valueCount);
            NullableVarBinaryVector.this.bits.getMutator().setValueCount(valueCount);
        }

        public void generateTestData(int valueCount) {
            NullableVarBinaryVector.this.bits.getMutator().generateTestDataAlt(valueCount);
            NullableVarBinaryVector.this.values.getMutator().generateTestData(valueCount);
            this.lastSet = valueCount;
            this.setValueCount(valueCount);
        }

        public void reset() {
            this.setCount = 0;
            this.lastSet = -1;
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor
    implements VariableWidthVector.VariableWidthAccessor {
        final UInt1Vector.Accessor bAccessor;
        final VarBinaryVector.Accessor vAccessor;

        public Accessor() {
            this.bAccessor = NullableVarBinaryVector.this.bits.getAccessor();
            this.vAccessor = NullableVarBinaryVector.this.values.getAccessor();
        }

        public byte[] get(int index) {
            if (this.isNull(index)) {
                throw new IllegalStateException("Can't get a null value");
            }
            return this.vAccessor.get(index);
        }

        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        public long getStartEnd(int index) {
            return this.vAccessor.getStartEnd(index);
        }

        public int getValueLength(int index) {
            return NullableVarBinaryVector.this.values.getAccessor().getValueLength(index);
        }

        public void get(int index, NullableVarBinaryHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
        }

        public byte[] getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        public int getValueCount() {
            return NullableVarBinaryVector.this.bits.getAccessor().getValueCount();
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        NullableVarBinaryVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new NullableVarBinaryVector(field, NullableVarBinaryVector.this.allocator);
        }

        public TransferImpl(NullableVarBinaryVector to) {
            this.to = to;
        }

        public NullableVarBinaryVector getTo() {
            return this.to;
        }

        public void transfer() {
            NullableVarBinaryVector.this.transferTo(this.to);
        }

        public void splitAndTransfer(int startIndex, int length) {
            NullableVarBinaryVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, NullableVarBinaryVector.this);
        }
    }
}

