/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import java.nio.ByteBuffer;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.NullableVectorDefinitionSetter;
import org.apache.drill.exec.vector.TimeStampVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.impl.NullableTimeStampReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NullableTimeStampVector
extends BaseDataValueVector
implements FixedWidthVector,
NullableVector {
    private static final Logger logger = LoggerFactory.getLogger(NullableTimeStampVector.class);
    private final FieldReader reader = new NullableTimeStampReaderImpl(this);
    private final MaterializedField bitsField = MaterializedField.create((String)"$bits$", (TypeProtos.MajorType)Types.required((TypeProtos.MinorType)TypeProtos.MinorType.UINT1));
    private final UInt1Vector bits = new UInt1Vector(this.bitsField, this.allocator);
    private final TimeStampVector values = new TimeStampVector(this.field, this.allocator);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public NullableTimeStampVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public FieldReader getReader() {
        return this.reader;
    }

    public int getValueCapacity() {
        return Math.min(this.bits.getValueCapacity(), this.values.getValueCapacity());
    }

    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = (DrillBuf[])ObjectArrays.concat((Object[])this.bits.getBuffers(false), (Object[])this.values.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    public void close() {
        this.bits.close();
        this.values.close();
        super.close();
    }

    public void clear() {
        this.bits.clear();
        this.values.clear();
        super.clear();
    }

    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.values.getBufferSizeFor(valueCount) + this.bits.getBufferSizeFor(valueCount);
    }

    public DrillBuf getBuffer() {
        return this.values.getBuffer();
    }

    public TimeStampVector getValuesVector() {
        return this.values;
    }

    public void setInitialCapacity(int numRecords) {
        this.bits.setInitialCapacity(numRecords);
        this.values.setInitialCapacity(numRecords);
    }

    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.bits.getMetadata()).addChild(this.values.getMetadata());
    }

    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            success = this.values.allocateNewSafe() && this.bits.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return success;
    }

    public void allocateNew(int valueCount) {
        try {
            this.values.allocateNew(valueCount);
            this.bits.allocateNew(valueCount + 1);
        }
        catch (OutOfMemoryRuntimeException e) {
            this.clear();
            throw e;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    public void reset() {
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        super.reset();
    }

    public void zeroVector() {
        this.bits.zeroVector();
        this.values.zeroVector();
    }

    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        this.bits.load(bitsField, buffer);
        int capacity = buffer.capacity();
        int bitsLength = bitsField.getBufferLength();
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        this.values.load(valuesField, buffer.slice(bitsLength, capacity - bitsLength));
    }

    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath((SchemaPath)ref));
    }

    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableTimeStampVector)to);
    }

    public void transferTo(NullableTimeStampVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, NullableTimeStampVector target) {
        this.bits.splitAndTransferTo(startIndex, length, target.bits);
        this.values.splitAndTransferTo(startIndex, length, target.values);
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public TimeStampVector convertToRequiredVector() {
        TimeStampVector v = new TimeStampVector(this.getField().getOtherNullableVersion(), this.allocator);
        if (v.data != null) {
            v.data.release(1);
        }
        v.data = this.values.data;
        v.data.retain(1);
        this.clear();
        return v;
    }

    public void copyFrom(int fromIndex, int thisIndex, NullableTimeStampVector from) {
        Accessor fromAccessor = from.getAccessor();
        if (!fromAccessor.isNull(fromIndex)) {
            this.mutator.set(thisIndex, fromAccessor.get(fromIndex));
        }
    }

    public void copyFromSafe(int fromIndex, int thisIndex, TimeStampVector from) {
        this.values.copyFromSafe(fromIndex, thisIndex, from);
        this.bits.getMutator().setSafe(thisIndex, 1);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, NullableTimeStampVector from) {
        this.bits.copyFromSafe(fromIndex, thisIndex, from.bits);
        this.values.copyFromSafe(fromIndex, thisIndex, from.values);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements NullableVectorDefinitionSetter {
        private int setCount;

        private Mutator() {
        }

        public TimeStampVector getVectorWithValues() {
            return NullableTimeStampVector.this.values;
        }

        public void setIndexDefined(int index) {
            NullableTimeStampVector.this.bits.getMutator().set(index, 1);
        }

        public void set(int index, long value) {
            ++this.setCount;
            TimeStampVector.Mutator valuesMutator = NullableTimeStampVector.this.values.getMutator();
            UInt1Vector.Mutator bitsMutator = NullableTimeStampVector.this.bits.getMutator();
            bitsMutator.set(index, 1);
            valuesMutator.set(index, value);
        }

        public void setSafe(int index, byte[] value, int start, int length) {
            throw new UnsupportedOperationException();
        }

        public void setSafe(int index, ByteBuffer value, int start, int length) {
            throw new UnsupportedOperationException();
        }

        public void setNull(int index) {
            NullableTimeStampVector.this.bits.getMutator().setSafe(index, 0);
        }

        public void setSkipNull(int index, TimeStampHolder holder) {
            NullableTimeStampVector.this.values.getMutator().set(index, holder);
        }

        public void setSkipNull(int index, NullableTimeStampHolder holder) {
            NullableTimeStampVector.this.values.getMutator().set(index, holder);
        }

        public void set(int index, NullableTimeStampHolder holder) {
            TimeStampVector.Mutator valuesMutator = NullableTimeStampVector.this.values.getMutator();
            NullableTimeStampVector.this.bits.getMutator().set(index, holder.isSet);
            valuesMutator.set(index, holder);
        }

        public void set(int index, TimeStampHolder holder) {
            TimeStampVector.Mutator valuesMutator = NullableTimeStampVector.this.values.getMutator();
            NullableTimeStampVector.this.bits.getMutator().set(index, 1);
            valuesMutator.set(index, holder);
        }

        public boolean isSafe(int outIndex) {
            return outIndex < NullableTimeStampVector.this.getValueCapacity();
        }

        public void set(int index, int isSet, long valueField) {
            TimeStampVector.Mutator valuesMutator = NullableTimeStampVector.this.values.getMutator();
            NullableTimeStampVector.this.bits.getMutator().set(index, isSet);
            valuesMutator.set(index, valueField);
        }

        public void setSafe(int index, int isSet, long valueField) {
            NullableTimeStampVector.this.bits.getMutator().setSafe(index, isSet);
            NullableTimeStampVector.this.values.getMutator().setSafe(index, valueField);
            ++this.setCount;
        }

        public void setSafe(int index, NullableTimeStampHolder value) {
            NullableTimeStampVector.this.bits.getMutator().setSafe(index, value.isSet);
            NullableTimeStampVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        public void setSafe(int index, TimeStampHolder value) {
            NullableTimeStampVector.this.bits.getMutator().setSafe(index, 1);
            NullableTimeStampVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        public void setSafe(int index, long value) {
            NullableTimeStampVector.this.bits.getMutator().setSafe(index, 1);
            NullableTimeStampVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableTimeStampVector.this.values.getMutator().setValueCount(valueCount);
            NullableTimeStampVector.this.bits.getMutator().setValueCount(valueCount);
        }

        public void generateTestData(int valueCount) {
            NullableTimeStampVector.this.bits.getMutator().generateTestDataAlt(valueCount);
            NullableTimeStampVector.this.values.getMutator().generateTestData(valueCount);
            this.setValueCount(valueCount);
        }

        public void reset() {
            this.setCount = 0;
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final UInt1Vector.Accessor bAccessor;
        final TimeStampVector.Accessor vAccessor;

        public Accessor() {
            this.bAccessor = NullableTimeStampVector.this.bits.getAccessor();
            this.vAccessor = NullableTimeStampVector.this.values.getAccessor();
        }

        public long get(int index) {
            if (this.isNull(index)) {
                throw new IllegalStateException("Can't get a null value");
            }
            return this.vAccessor.get(index);
        }

        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        public void get(int index, NullableTimeStampHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
        }

        public DateTime getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        public int getValueCount() {
            return NullableTimeStampVector.this.bits.getAccessor().getValueCount();
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        NullableTimeStampVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new NullableTimeStampVector(field, NullableTimeStampVector.this.allocator);
        }

        public TransferImpl(NullableTimeStampVector to) {
            this.to = to;
        }

        public NullableTimeStampVector getTo() {
            return this.to;
        }

        public void transfer() {
            NullableTimeStampVector.this.transferTo(this.to);
        }

        public void splitAndTransfer(int startIndex, int length) {
            NullableTimeStampVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, NullableTimeStampVector.this);
        }
    }
}

