/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.exception.OversizedAllocationException;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.apache.drill.exec.vector.complex.impl.IntervalYearReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntervalYearVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(IntervalYearVector.class);
    private final FieldReader reader = new IntervalYearReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = 16384;
    private int allocationMonitor = 0;

    public IntervalYearVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public FieldReader getReader() {
        return this.reader;
    }

    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 4;
    }

    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 4.0);
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public void setInitialCapacity(int valueCount) {
        long size = 1L * (long)valueCount * 4L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 4);
    }

    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize = (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", new Object[]{this.field, this.allocationSizeInBytes, newAllocationSize});
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, (ByteBuf)this.data, 0, this.data.capacity());
        int halfNewCapacity = newBuf.capacity() / 2;
        newBuf.setZero(halfNewCapacity, halfNewCapacity);
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument((boolean)this.field.matches(metadata), (String)"The field %s doesn't match the provided metadata %s.", (Object[])new Object[]{this.field, metadata});
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 4;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath((SchemaPath)ref));
    }

    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntervalYearVector)to);
    }

    public void transferTo(IntervalYearVector target) {
        target.clear();
        target.data = this.data;
        target.data.retain(1);
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, IntervalYearVector target) {
        int startPoint = startIndex * 4;
        int sliceLength = length * 4;
        target.clear();
        target.data = this.data.slice(startPoint, sliceLength);
        target.data.retain(1);
        target.data.writerIndex(sliceLength);
    }

    public void copyFrom(int fromIndex, int thisIndex, IntervalYearVector from) {
        this.data.setInt(thisIndex * 4, from.data.getInt(fromIndex * 4));
    }

    public void copyFromSafe(int fromIndex, int thisIndex, IntervalYearVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, int value) {
            IntervalYearVector.this.data.setInt(index * 4, value);
        }

        public void setSafe(int index, int value) {
            while (index >= IntervalYearVector.this.getValueCapacity()) {
                IntervalYearVector.this.reAlloc();
            }
            this.set(index, value);
        }

        protected void set(int index, IntervalYearHolder holder) {
            IntervalYearVector.this.data.setInt(index * 4, holder.value);
        }

        public void setSafe(int index, IntervalYearHolder holder) {
            while (index >= IntervalYearVector.this.getValueCapacity()) {
                IntervalYearVector.this.reAlloc();
            }
            this.set(index, holder);
        }

        protected void set(int index, NullableIntervalYearHolder holder) {
            IntervalYearVector.this.data.setInt(index * 4, holder.value);
        }

        public void setSafe(int index, NullableIntervalYearHolder holder) {
            while (index >= IntervalYearVector.this.getValueCapacity()) {
                IntervalYearVector.this.reAlloc();
            }
            this.set(index, holder);
        }

        public void generateTestData(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = IntervalYearVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, Integer.MIN_VALUE);
                } else {
                    this.set(i, Integer.MAX_VALUE);
                }
                even = !even;
            }
        }

        public void generateTestDataAlt(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = IntervalYearVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, 1);
                } else {
                    this.set(i, 0);
                }
                even = !even;
            }
        }

        public void setValueCount(int valueCount) {
            int currentValueCapacity = IntervalYearVector.this.getValueCapacity();
            int idx = 4 * valueCount;
            while (valueCount > IntervalYearVector.this.getValueCapacity()) {
                IntervalYearVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                IntervalYearVector.this.incrementAllocationMonitor();
            } else if (IntervalYearVector.this.allocationMonitor > 0) {
                IntervalYearVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim((ByteBuf)IntervalYearVector.this.data, (int)idx);
            IntervalYearVector.this.data.writerIndex(valueCount * 4);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        public int getValueCount() {
            return IntervalYearVector.this.data.writerIndex() / 4;
        }

        public boolean isNull(int index) {
            return false;
        }

        public int get(int index) {
            return IntervalYearVector.this.data.getInt(index * 4);
        }

        public long getTwoAsLong(int index) {
            return IntervalYearVector.this.data.getLong(index * 4);
        }

        public Period getObject(int index) {
            int value = this.get(index);
            int years = value / 12;
            int months = value % 12;
            Period p = new Period();
            return p.plusYears(years).plusMonths(months);
        }

        public StringBuilder getAsStringBuilder(int index) {
            int months = IntervalYearVector.this.data.getInt(index);
            int years = months / 12;
            String yearString = Math.abs(years) == 1 ? " year " : " years ";
            String monthString = Math.abs(months %= 12) == 1 ? " month " : " months ";
            return new StringBuilder().append(years).append(yearString).append(months).append(monthString);
        }

        public void get(int index, IntervalYearHolder holder) {
            holder.value = IntervalYearVector.this.data.getInt(index * 4);
        }

        public void get(int index, NullableIntervalYearHolder holder) {
            holder.isSet = 1;
            holder.value = IntervalYearVector.this.data.getInt(index * 4);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private IntervalYearVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new IntervalYearVector(field, IntervalYearVector.this.allocator);
        }

        public TransferImpl(IntervalYearVector to) {
            this.to = to;
        }

        public IntervalYearVector getTo() {
            return this.to;
        }

        public void transfer() {
            IntervalYearVector.this.transferTo(this.to);
        }

        public void splitAndTransfer(int startIndex, int length) {
            IntervalYearVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, IntervalYearVector.this);
        }
    }
}

