/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.exception.OversizedAllocationException;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.apache.drill.exec.vector.complex.impl.IntervalReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntervalVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(IntervalVector.class);
    private final FieldReader reader = new IntervalReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = 65536;
    private int allocationMonitor = 0;

    public IntervalVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public FieldReader getReader() {
        return this.reader;
    }

    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 16;
    }

    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 16.0);
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public void setInitialCapacity(int valueCount) {
        long size = 1L * (long)valueCount * 16L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 16);
    }

    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize = (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", new Object[]{this.field, this.allocationSizeInBytes, newAllocationSize});
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, (ByteBuf)this.data, 0, this.data.capacity());
        int halfNewCapacity = newBuf.capacity() / 2;
        newBuf.setZero(halfNewCapacity, halfNewCapacity);
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument((boolean)this.field.matches(metadata), (String)"The field %s doesn't match the provided metadata %s.", (Object[])new Object[]{this.field, metadata});
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 16;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath((SchemaPath)ref));
    }

    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntervalVector)to);
    }

    public void transferTo(IntervalVector target) {
        target.clear();
        target.data = this.data;
        target.data.retain(1);
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, IntervalVector target) {
        int startPoint = startIndex * 16;
        int sliceLength = length * 16;
        target.clear();
        target.data = this.data.slice(startPoint, sliceLength);
        target.data.retain(1);
        target.data.writerIndex(sliceLength);
    }

    public void copyFrom(int fromIndex, int thisIndex, IntervalVector from) {
        from.data.getBytes(fromIndex * 16, (ByteBuf)this.data, thisIndex * 16, 16);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, IntervalVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, DrillBuf value) {
            IntervalVector.this.data.setBytes(index * 16, (ByteBuf)value, 0, 16);
        }

        public void setSafe(int index, DrillBuf value) {
            while (index >= IntervalVector.this.getValueCapacity()) {
                IntervalVector.this.reAlloc();
            }
            IntervalVector.this.data.setBytes(index * 16, (ByteBuf)value, 0, 16);
        }

        public void set(int index, int months, int days, int milliseconds) {
            int offsetIndex = index * 16;
            IntervalVector.this.data.setInt(offsetIndex, months);
            IntervalVector.this.data.setInt(offsetIndex + 4, days);
            IntervalVector.this.data.setInt(offsetIndex + 8, milliseconds);
        }

        protected void set(int index, IntervalHolder holder) {
            this.set(index, holder.months, holder.days, holder.milliseconds);
        }

        protected void set(int index, NullableIntervalHolder holder) {
            this.set(index, holder.months, holder.days, holder.milliseconds);
        }

        public void setSafe(int index, int months, int days, int milliseconds) {
            while (index >= IntervalVector.this.getValueCapacity()) {
                IntervalVector.this.reAlloc();
            }
            this.set(index, months, days, milliseconds);
        }

        public void setSafe(int index, NullableIntervalHolder holder) {
            this.setSafe(index, holder.months, holder.days, holder.milliseconds);
        }

        public void setSafe(int index, IntervalHolder holder) {
            this.setSafe(index, holder.months, holder.days, holder.milliseconds);
        }

        public void generateTestData(int count) {
            this.setValueCount(count);
            boolean even = true;
            int valueCount = IntervalVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                byte b = even ? (byte)-128 : 127;
                for (int w = 0; w < 16; ++w) {
                    IntervalVector.this.data.setByte(i + w, b);
                }
                even = !even;
            }
        }

        public void setValueCount(int valueCount) {
            int currentValueCapacity = IntervalVector.this.getValueCapacity();
            int idx = 16 * valueCount;
            while (valueCount > IntervalVector.this.getValueCapacity()) {
                IntervalVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                IntervalVector.this.incrementAllocationMonitor();
            } else if (IntervalVector.this.allocationMonitor > 0) {
                IntervalVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim((ByteBuf)IntervalVector.this.data, (int)idx);
            IntervalVector.this.data.writerIndex(valueCount * 16);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        public int getValueCount() {
            return IntervalVector.this.data.writerIndex() / 16;
        }

        public boolean isNull(int index) {
            return false;
        }

        public DrillBuf get(int index) {
            return IntervalVector.this.data.slice(index * 16, 16);
        }

        public void get(int index, IntervalHolder holder) {
            int offsetIndex = index * 16;
            holder.months = IntervalVector.this.data.getInt(offsetIndex);
            holder.days = IntervalVector.this.data.getInt(offsetIndex + 4);
            holder.milliseconds = IntervalVector.this.data.getInt(offsetIndex + 8);
        }

        public void get(int index, NullableIntervalHolder holder) {
            int offsetIndex = index * 16;
            holder.isSet = 1;
            holder.months = IntervalVector.this.data.getInt(offsetIndex);
            holder.days = IntervalVector.this.data.getInt(offsetIndex + 4);
            holder.milliseconds = IntervalVector.this.data.getInt(offsetIndex + 8);
        }

        public Period getObject(int index) {
            int offsetIndex = index * 16;
            int months = IntervalVector.this.data.getInt(offsetIndex);
            int days = IntervalVector.this.data.getInt(offsetIndex + 4);
            int millis = IntervalVector.this.data.getInt(offsetIndex + 8);
            Period p = new Period();
            return p.plusMonths(months).plusDays(days).plusMillis(millis);
        }

        public StringBuilder getAsStringBuilder(int index) {
            int offsetIndex = index * 16;
            int months = IntervalVector.this.data.getInt(offsetIndex);
            int days = IntervalVector.this.data.getInt(offsetIndex + 4);
            int millis = IntervalVector.this.data.getInt(offsetIndex + 8);
            int years = months / 12;
            months %= 12;
            int hours = millis / 3600000;
            int minutes = (millis %= 3600000) / 60000;
            long seconds = (millis %= 60000) / 1000;
            String yearString = Math.abs(years) == 1 ? " year " : " years ";
            String monthString = Math.abs(months) == 1 ? " month " : " months ";
            String dayString = Math.abs(days) == 1 ? " day " : " days ";
            return new StringBuilder().append(years).append(yearString).append(months).append(monthString).append(days).append(dayString).append(hours).append(":").append(minutes).append(":").append(seconds).append(".").append(millis %= 1000);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private IntervalVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new IntervalVector(field, IntervalVector.this.allocator);
        }

        public TransferImpl(IntervalVector to) {
            this.to = to;
        }

        public IntervalVector getTo() {
            return this.to;
        }

        public void transfer() {
            IntervalVector.this.transferTo(this.to);
        }

        public void splitAndTransfer(int startIndex, int length) {
            IntervalVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, IntervalVector.this);
        }
    }
}

