/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.exception.OversizedAllocationException;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.apache.drill.exec.vector.complex.impl.Decimal38SparseReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Decimal38SparseVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(Decimal38SparseVector.class);
    private final FieldReader reader = new Decimal38SparseReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = 98304;
    private int allocationMonitor = 0;

    public Decimal38SparseVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public FieldReader getReader() {
        return this.reader;
    }

    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 24;
    }

    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 24.0);
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public void setInitialCapacity(int valueCount) {
        long size = 1L * (long)valueCount * 24L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 24);
    }

    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize = (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", new Object[]{this.field, this.allocationSizeInBytes, newAllocationSize});
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, (ByteBuf)this.data, 0, this.data.capacity());
        int halfNewCapacity = newBuf.capacity() / 2;
        newBuf.setZero(halfNewCapacity, halfNewCapacity);
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument((boolean)this.field.matches(metadata), (String)"The field %s doesn't match the provided metadata %s.", (Object[])new Object[]{this.field, metadata});
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 24;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath((SchemaPath)ref));
    }

    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((Decimal38SparseVector)to);
    }

    public void transferTo(Decimal38SparseVector target) {
        target.clear();
        target.data = this.data;
        target.data.retain(1);
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, Decimal38SparseVector target) {
        int startPoint = startIndex * 24;
        int sliceLength = length * 24;
        target.clear();
        target.data = this.data.slice(startPoint, sliceLength);
        target.data.retain(1);
        target.data.writerIndex(sliceLength);
    }

    public void copyFrom(int fromIndex, int thisIndex, Decimal38SparseVector from) {
        from.data.getBytes(fromIndex * 24, (ByteBuf)this.data, thisIndex * 24, 24);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, Decimal38SparseVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, DrillBuf value) {
            Decimal38SparseVector.this.data.setBytes(index * 24, (ByteBuf)value, 0, 24);
        }

        public void setSafe(int index, DrillBuf value) {
            while (index >= Decimal38SparseVector.this.getValueCapacity()) {
                Decimal38SparseVector.this.reAlloc();
            }
            Decimal38SparseVector.this.data.setBytes(index * 24, (ByteBuf)value, 0, 24);
        }

        public void set(int index, Decimal38SparseHolder holder) {
            this.set(index, holder.start, holder.buffer);
        }

        void set(int index, NullableDecimal38SparseHolder holder) {
            this.set(index, holder.start, holder.buffer);
        }

        public void setSafe(int index, NullableDecimal38SparseHolder holder) {
            this.setSafe(index, holder.start, holder.buffer);
        }

        public void setSafe(int index, Decimal38SparseHolder holder) {
            this.setSafe(index, holder.start, holder.buffer);
        }

        public void setSafe(int index, int start, DrillBuf buffer) {
            while (index >= Decimal38SparseVector.this.getValueCapacity()) {
                Decimal38SparseVector.this.reAlloc();
            }
            this.set(index, start, buffer);
        }

        public void set(int index, int start, DrillBuf buffer) {
            Decimal38SparseVector.this.data.setBytes(index * 24, (ByteBuf)buffer, start, 24);
        }

        public void generateTestData(int count) {
            this.setValueCount(count);
            boolean even = true;
            int valueCount = Decimal38SparseVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                byte b = even ? (byte)-128 : 127;
                for (int w = 0; w < 24; ++w) {
                    Decimal38SparseVector.this.data.setByte(i + w, b);
                }
                even = !even;
            }
        }

        public void setValueCount(int valueCount) {
            int currentValueCapacity = Decimal38SparseVector.this.getValueCapacity();
            int idx = 24 * valueCount;
            while (valueCount > Decimal38SparseVector.this.getValueCapacity()) {
                Decimal38SparseVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                Decimal38SparseVector.this.incrementAllocationMonitor();
            } else if (Decimal38SparseVector.this.allocationMonitor > 0) {
                Decimal38SparseVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim((ByteBuf)Decimal38SparseVector.this.data, (int)idx);
            Decimal38SparseVector.this.data.writerIndex(valueCount * 24);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        public int getValueCount() {
            return Decimal38SparseVector.this.data.writerIndex() / 24;
        }

        public boolean isNull(int index) {
            return false;
        }

        public DrillBuf get(int index) {
            return Decimal38SparseVector.this.data.slice(index * 24, 24);
        }

        public void get(int index, Decimal38SparseHolder holder) {
            holder.start = index * 24;
            holder.buffer = Decimal38SparseVector.this.data;
            holder.scale = Decimal38SparseVector.this.getField().getScale();
            holder.precision = Decimal38SparseVector.this.getField().getPrecision();
        }

        public void get(int index, NullableDecimal38SparseHolder holder) {
            holder.isSet = 1;
            holder.start = index * 24;
            holder.buffer = Decimal38SparseVector.this.data;
            holder.scale = Decimal38SparseVector.this.getField().getScale();
            holder.precision = Decimal38SparseVector.this.getField().getPrecision();
        }

        public BigDecimal getObject(int index) {
            return DecimalUtility.getBigDecimalFromSparse((DrillBuf)Decimal38SparseVector.this.data, (int)(index * 24), (int)6, (int)Decimal38SparseVector.this.getField().getScale());
        }
    }

    private class TransferImpl
    implements TransferPair {
        private Decimal38SparseVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new Decimal38SparseVector(field, Decimal38SparseVector.this.allocator);
        }

        public TransferImpl(Decimal38SparseVector to) {
            this.to = to;
        }

        public Decimal38SparseVector getTo() {
            return this.to;
        }

        public void transfer() {
            Decimal38SparseVector.this.transferTo(this.to);
        }

        public void splitAndTransfer(int startIndex, int length) {
            Decimal38SparseVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, Decimal38SparseVector.this);
        }
    }
}

