/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.exception.OversizedAllocationException;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.apache.drill.exec.vector.complex.impl.DateReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(DateVector.class);
    private final FieldReader reader = new DateReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = 32768;
    private int allocationMonitor = 0;

    public DateVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public FieldReader getReader() {
        return this.reader;
    }

    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 8;
    }

    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 8.0);
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Mutator getMutator() {
        return this.mutator;
    }

    public void setInitialCapacity(int valueCount) {
        long size = 1L * (long)valueCount * 8L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 8);
    }

    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize = (long)this.allocationSizeInBytes * 2L;
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", new Object[]{this.field, this.allocationSizeInBytes, newAllocationSize});
        DrillBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, (ByteBuf)this.data, 0, this.data.capacity());
        int halfNewCapacity = newBuf.capacity() / 2;
        newBuf.setZero(halfNewCapacity, halfNewCapacity);
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = (int)newAllocationSize;
    }

    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument((boolean)this.field.matches(metadata), (String)"The field %s doesn't match the provided metadata %s.", (Object[])new Object[]{this.field, metadata});
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 8;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    public TransferPair getTransferPair(FieldReference ref) {
        return new TransferImpl(this.getField().withPath((SchemaPath)ref));
    }

    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((DateVector)to);
    }

    public void transferTo(DateVector target) {
        target.clear();
        target.data = this.data;
        target.data.retain(1);
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, DateVector target) {
        int startPoint = startIndex * 8;
        int sliceLength = length * 8;
        target.clear();
        target.data = this.data.slice(startPoint, sliceLength);
        target.data.retain(1);
        target.data.writerIndex(sliceLength);
    }

    public void copyFrom(int fromIndex, int thisIndex, DateVector from) {
        this.data.setLong(thisIndex * 8, from.data.getLong(fromIndex * 8));
    }

    public void copyFromSafe(int fromIndex, int thisIndex, DateVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, long value) {
            DateVector.this.data.setLong(index * 8, value);
        }

        public void setSafe(int index, long value) {
            while (index >= DateVector.this.getValueCapacity()) {
                DateVector.this.reAlloc();
            }
            this.set(index, value);
        }

        protected void set(int index, DateHolder holder) {
            DateVector.this.data.setLong(index * 8, holder.value);
        }

        public void setSafe(int index, DateHolder holder) {
            while (index >= DateVector.this.getValueCapacity()) {
                DateVector.this.reAlloc();
            }
            this.set(index, holder);
        }

        protected void set(int index, NullableDateHolder holder) {
            DateVector.this.data.setLong(index * 8, holder.value);
        }

        public void setSafe(int index, NullableDateHolder holder) {
            while (index >= DateVector.this.getValueCapacity()) {
                DateVector.this.reAlloc();
            }
            this.set(index, holder);
        }

        public void generateTestData(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = DateVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, Long.MIN_VALUE);
                } else {
                    this.set(i, Long.MAX_VALUE);
                }
                even = !even;
            }
        }

        public void generateTestDataAlt(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = DateVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, 1L);
                } else {
                    this.set(i, 0L);
                }
                even = !even;
            }
        }

        public void setValueCount(int valueCount) {
            int currentValueCapacity = DateVector.this.getValueCapacity();
            int idx = 8 * valueCount;
            while (valueCount > DateVector.this.getValueCapacity()) {
                DateVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                DateVector.this.incrementAllocationMonitor();
            } else if (DateVector.this.allocationMonitor > 0) {
                DateVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim((ByteBuf)DateVector.this.data, (int)idx);
            DateVector.this.data.writerIndex(valueCount * 8);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        public int getValueCount() {
            return DateVector.this.data.writerIndex() / 8;
        }

        public boolean isNull(int index) {
            return false;
        }

        public long get(int index) {
            return DateVector.this.data.getLong(index * 8);
        }

        public DateTime getObject(int index) {
            DateTime date = new DateTime(this.get(index), DateTimeZone.UTC);
            date = date.withZoneRetainFields(DateTimeZone.getDefault());
            return date;
        }

        public void get(int index, DateHolder holder) {
            holder.value = DateVector.this.data.getLong(index * 8);
        }

        public void get(int index, NullableDateHolder holder) {
            holder.isSet = 1;
            holder.value = DateVector.this.data.getLong(index * 8);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private DateVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new DateVector(field, DateVector.this.allocator);
        }

        public TransferImpl(DateVector to) {
            this.to = to;
        }

        public DateVector getTo() {
            return this.to;
        }

        public void transfer() {
            DateVector.this.transferTo(this.to);
        }

        public void splitAndTransfer(int startIndex, int length) {
            DateVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, DateVector.this);
        }
    }
}

