/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.util;

import org.apache.drill.exec.util.ArrayWrappedIntIntMap;
import org.junit.Assert;
import org.junit.Test;

public class TestArrayWrappedIntIntMap {
    @Test
    public void testSimple() {
        ArrayWrappedIntIntMap map = new ArrayWrappedIntIntMap();
        map.put(0, 0);
        map.put(1, 1);
        map.put(9, 9);
        Assert.assertEquals((long)0L, (long)map.get(0));
        Assert.assertEquals((long)1L, (long)map.get(1));
        Assert.assertEquals((long)9L, (long)map.get(9));
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testInvalidKeyAccess() {
        ArrayWrappedIntIntMap map = new ArrayWrappedIntIntMap();
        map.put(0, 0);
        map.put(1, 1);
        map.put(9, 9);
        Assert.assertEquals((long)0L, (long)map.get(0));
        Assert.assertEquals((long)1L, (long)map.get(1));
        Assert.assertEquals((long)9L, (long)map.get(9));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)map.get(2));
        map.get(256);
    }

    @Test
    public void testResizing() {
        int i;
        ArrayWrappedIntIntMap map = new ArrayWrappedIntIntMap();
        int[] expectedValues = new int[]{1, 32, 64, 150, 256, 4000};
        for (i = 0; i < expectedValues.length; ++i) {
            map.put(expectedValues[i], expectedValues[i]);
        }
        for (i = 0; i < expectedValues.length; ++i) {
            Assert.assertEquals((long)expectedValues[i], (long)map.get(expectedValues[i]));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidKeyBelowMinValueSupported() {
        ArrayWrappedIntIntMap map = new ArrayWrappedIntIntMap();
        map.put(-1, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidKeyAboveMaxKeyValueSupported() {
        ArrayWrappedIntIntMap map = new ArrayWrappedIntIntMap();
        map.put(65536, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValuePut() {
        ArrayWrappedIntIntMap map = new ArrayWrappedIntIntMap();
        map.put(1, -1);
    }
}

