/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;

public class MiniZooKeeperCluster {
    private static final Log LOG = LogFactory.getLog(MiniZooKeeperCluster.class);
    private static final int TICK_TIME = 2000;
    private static final int CONNECTION_TIMEOUT = 30000;
    private boolean started = false;
    private int defaultClientPort = 0;
    private int clientPort;
    private List<NIOServerCnxnFactory> standaloneServerFactoryList;
    private List<ZooKeeperServer> zooKeeperServers = new ArrayList<ZooKeeperServer>();
    private List<Integer> clientPortList = new ArrayList<Integer>();
    private int activeZKServerIndex = -1;
    private int tickTime = 0;

    public MiniZooKeeperCluster() {
        this.standaloneServerFactoryList = new ArrayList<NIOServerCnxnFactory>();
    }

    public void setDefaultClientPort(int clientPort) {
        if (clientPort <= 0) {
            throw new IllegalArgumentException("Invalid default ZK client port: " + clientPort);
        }
        this.defaultClientPort = clientPort;
    }

    private int selectClientPort() {
        if (this.defaultClientPort > 0) {
            return this.defaultClientPort;
        }
        return 49152 + new Random().nextInt(16128);
    }

    public void setTickTime(int tickTime) {
        this.tickTime = tickTime;
    }

    public int getBackupZooKeeperServerNum() {
        return this.zooKeeperServers.size() - 1;
    }

    public int getZooKeeperServerNum() {
        return this.zooKeeperServers.size();
    }

    private static void setupTestEnv() {
        System.setProperty("zookeeper.preAllocSize", "100");
        FileTxnLog.setPreallocSize((long)102400L);
    }

    public int startup(File baseDir) throws IOException, InterruptedException {
        return this.startup(baseDir, 1);
    }

    public int startup(File baseDir, int numZooKeeperServers) throws IOException, InterruptedException {
        if (numZooKeeperServers <= 0) {
            return -1;
        }
        MiniZooKeeperCluster.setupTestEnv();
        this.shutdown();
        int tentativePort = this.selectClientPort();
        for (int i = 0; i < numZooKeeperServers; ++i) {
            NIOServerCnxnFactory standaloneServerFactory;
            File dir = new File(baseDir, "zookeeper_" + i).getAbsoluteFile();
            this.recreateDir(dir);
            int tickTimeToUse = this.tickTime > 0 ? this.tickTime : 2000;
            ZooKeeperServer server = new ZooKeeperServer(dir, dir, tickTimeToUse);
            while (true) {
                try {
                    standaloneServerFactory = new NIOServerCnxnFactory();
                    standaloneServerFactory.configure(new InetSocketAddress(tentativePort), 1000);
                }
                catch (BindException e) {
                    LOG.debug((Object)("Failed binding ZK Server to client port: " + tentativePort));
                    ++tentativePort;
                    continue;
                }
                break;
            }
            standaloneServerFactory.startup(server);
            if (!MiniZooKeeperCluster.waitForServerUp(tentativePort, 30000L)) {
                throw new IOException("Waiting for startup of standalone server");
            }
            this.clientPortList.add(tentativePort);
            this.standaloneServerFactoryList.add(standaloneServerFactory);
            this.zooKeeperServers.add(server);
        }
        this.activeZKServerIndex = 0;
        this.started = true;
        this.clientPort = this.clientPortList.get(this.activeZKServerIndex);
        LOG.info((Object)("Started MiniZK Cluster and connect 1 ZK server on client port: " + this.clientPort));
        return this.clientPort;
    }

    private void recreateDir(File dir) throws IOException {
        if (dir.exists()) {
            FileUtil.fullyDelete((File)dir);
        }
        try {
            dir.mkdirs();
        }
        catch (SecurityException e) {
            throw new IOException("creating dir: " + dir, e);
        }
    }

    public void shutdown() throws IOException {
        if (!this.started) {
            return;
        }
        for (int i = 0; i < this.standaloneServerFactoryList.size(); ++i) {
            NIOServerCnxnFactory standaloneServerFactory = this.standaloneServerFactoryList.get(i);
            int clientPort = this.clientPortList.get(i);
            standaloneServerFactory.shutdown();
            if (MiniZooKeeperCluster.waitForServerDown(clientPort, 30000L)) continue;
            throw new IOException("Waiting for shutdown of standalone server");
        }
        this.started = false;
        this.activeZKServerIndex = 0;
        this.standaloneServerFactoryList.clear();
        this.clientPortList.clear();
        this.zooKeeperServers.clear();
        LOG.info((Object)"Shutdown MiniZK cluster with all ZK servers");
    }

    public int killCurrentActiveZooKeeperServer() throws IOException, InterruptedException {
        if (!this.started || this.activeZKServerIndex < 0) {
            return -1;
        }
        NIOServerCnxnFactory standaloneServerFactory = this.standaloneServerFactoryList.get(this.activeZKServerIndex);
        int clientPort = this.clientPortList.get(this.activeZKServerIndex);
        standaloneServerFactory.shutdown();
        if (!MiniZooKeeperCluster.waitForServerDown(clientPort, 30000L)) {
            throw new IOException("Waiting for shutdown of standalone server");
        }
        this.standaloneServerFactoryList.remove(this.activeZKServerIndex);
        this.clientPortList.remove(this.activeZKServerIndex);
        this.zooKeeperServers.remove(this.activeZKServerIndex);
        LOG.info((Object)("Kill the current active ZK servers in the cluster on client port: " + clientPort));
        if (this.standaloneServerFactoryList.size() == 0) {
            return -1;
        }
        clientPort = this.clientPortList.get(this.activeZKServerIndex);
        LOG.info((Object)("Activate a backup zk server in the cluster on client port: " + clientPort));
        return clientPort;
    }

    public void killOneBackupZooKeeperServer() throws IOException, InterruptedException {
        if (!this.started || this.activeZKServerIndex < 0 || this.standaloneServerFactoryList.size() <= 1) {
            return;
        }
        int backupZKServerIndex = this.activeZKServerIndex + 1;
        NIOServerCnxnFactory standaloneServerFactory = this.standaloneServerFactoryList.get(backupZKServerIndex);
        int clientPort = this.clientPortList.get(backupZKServerIndex);
        standaloneServerFactory.shutdown();
        if (!MiniZooKeeperCluster.waitForServerDown(clientPort, 30000L)) {
            throw new IOException("Waiting for shutdown of standalone server");
        }
        this.standaloneServerFactoryList.remove(backupZKServerIndex);
        this.clientPortList.remove(backupZKServerIndex);
        this.zooKeeperServers.remove(backupZKServerIndex);
        LOG.info((Object)("Kill one backup ZK servers in the cluster on client port: " + clientPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForServerDown(int port, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try (Socket sock = new Socket("localhost", port);){
                OutputStream outstream = sock.getOutputStream();
                outstream.write("stat".getBytes());
                outstream.flush();
            }
            catch (IOException e) {
                return true;
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean waitForServerUp(int port, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                Socket sock = new Socket("localhost", port);
                BufferedReader reader = null;
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes());
                    outstream.flush();
                    InputStreamReader isr = new InputStreamReader(sock.getInputStream());
                    reader = new BufferedReader(isr);
                    String line = reader.readLine();
                    if (line != null && line.startsWith("Zookeeper version:")) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    sock.close();
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                LOG.info((Object)("server localhost:" + port + " not up " + e));
            }
            if (System.currentTimeMillis() > start + timeout) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public int getClientPort() {
        return this.clientPort;
    }
}

