/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.testing;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.drill.QueryTestUtil;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.test.DrillTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestResourceLeak
extends DrillTest {
    private static DrillClient client;
    private static Drillbit bit;
    private static RemoteServiceSet serviceSet;
    private static DrillConfig config;
    private static BufferAllocator allocator;
    private static final Properties TEST_CONFIGURATIONS;

    @BeforeClass
    public static void openClient() throws Exception {
        config = DrillConfig.create((Properties)TEST_CONFIGURATIONS);
        allocator = RootAllocatorFactory.newRoot((DrillConfig)config);
        serviceSet = RemoteServiceSet.getLocalServiceSet();
        bit = new Drillbit(config, serviceSet);
        bit.run();
        client = QueryTestUtil.createClient(config, serviceSet, 2, null);
    }

    @Test
    public void tpch01() throws Exception {
        String query = TestResourceLeak.getFile("memory/tpch01_memory_leak.sql");
        try {
            QueryTestUtil.test(client, "alter session set `planner.slice_target` = 10; " + query);
        }
        catch (UserRemoteException e) {
            if (e.getMessage().contains("Attempted to close accountor")) {
                return;
            }
            throw e;
        }
        Assert.fail((String)"Expected UserRemoteException indicating memory leak");
    }

    private static String getFile(String resource) throws IOException {
        URL url = Resources.getResource((String)resource);
        if (url == null) {
            throw new IOException(String.format("Unable to find path %s.", resource));
        }
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    @AfterClass
    public static void closeClient() throws Exception {
        try {
            allocator.close();
            serviceSet.close();
            bit.close();
            client.close();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    static {
        TEST_CONFIGURATIONS = new Properties(){
            {
                this.put("drill.exec.sys.store.provider.local.write", "false");
                this.put("drill.exec.http.enabled", "false");
            }
        };
    }

    @FunctionTemplate(name="leakResource", scope=FunctionTemplate.FunctionScope.SIMPLE, nulls=FunctionTemplate.NullHandling.NULL_IF_NULL)
    public static class Leak
    implements DrillSimpleFunc {
        @Param
        Float8Holder in;
        @Inject
        DrillBuf buf;
        @Output
        Float8Holder out;

        public void setup() {
        }

        public void eval() {
            this.buf.getAllocator().buffer(1);
            this.out.value = this.in.value;
        }
    }
}

