/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.testing;

import java.io.IOException;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ZookeeperHelper;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.testing.Controls;
import org.apache.drill.exec.testing.ControlsInjectionUtil;
import org.apache.drill.exec.testing.ControlsInjector;
import org.apache.drill.exec.testing.ControlsInjectorFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestExceptionInjection
extends BaseTestQuery {
    private static final String NO_THROW_FAIL = "Didn't throw expected exception";
    private static final UserSession session = UserSession.Builder.newBuilder().withCredentials(UserBitShared.UserCredentials.newBuilder().setUserName("foo").build()).withUserProperties(UserProtos.UserProperties.getDefaultInstance()).withOptionManager((OptionManager)bits[0].getContext().getOptionManager()).build();

    @Test
    public void noInjection() throws Exception {
        TestExceptionInjection.test("select * from sys.memory");
    }

    @Test
    public void emptyInjection() throws Exception {
        ControlsInjectionUtil.setControls(session, "{\"injections\":[]}");
        TestExceptionInjection.test("select * from sys.memory");
    }

    private static void assertPassthroughThrows(DummyClass dummyClass, String exceptionClassName, String exceptionDesc) {
        try {
            dummyClass.descPassthroughMethod(exceptionDesc);
            Assert.fail((String)NO_THROW_FAIL);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)exceptionClassName, (Object)e.getClass().getName());
            Assert.assertEquals((Object)exceptionDesc, (Object)e.getMessage());
        }
    }

    @Test
    public void uncheckedInjection() {
        String exceptionDesc = "<<injected from descPassthroughMethod()>>";
        String exceptionClassName = "java.lang.RuntimeException";
        String jsonString = "{\"injections\":[{\"type\":\"exception\",\"siteClass\":\"org.apache.drill.exec.testing.TestExceptionInjection$DummyClass\",\"desc\":\"<<injected from descPassthroughMethod()>>\",\"nSkip\":0,\"nFire\":1,\"exceptionClass\":\"java.lang.RuntimeException\"}]}";
        ControlsInjectionUtil.setControls(session, "{\"injections\":[{\"type\":\"exception\",\"siteClass\":\"org.apache.drill.exec.testing.TestExceptionInjection$DummyClass\",\"desc\":\"<<injected from descPassthroughMethod()>>\",\"nSkip\":0,\"nFire\":1,\"exceptionClass\":\"java.lang.RuntimeException\"}]}");
        QueryContext context = new QueryContext(session, bits[0].getContext());
        DummyClass dummyClass = new DummyClass(context);
        TestExceptionInjection.assertPassthroughThrows(dummyClass, "java.lang.RuntimeException", "<<injected from descPassthroughMethod()>>");
        try {
            context.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void checkedInjection() {
        String controls = Controls.newBuilder().addException(DummyClass.class, "<<throwsIOException>>", IOException.class, 0, 1).build();
        ControlsInjectionUtil.setControls(session, controls);
        QueryContext context = new QueryContext(session, bits[0].getContext());
        DummyClass dummyClass = new DummyClass(context);
        try {
            dummyClass.throwsIOException();
            Assert.fail((String)NO_THROW_FAIL);
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"<<throwsIOException>>", (Object)e.getMessage());
        }
        try {
            context.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void skipAndLimit() {
        int i;
        String passthroughDesc = "<<injected from descPassthrough>>";
        int nSkip = 7;
        int nFire = 3;
        Class<RuntimeException> exceptionClass = RuntimeException.class;
        String controls = Controls.newBuilder().addException(DummyClass.class, "<<injected from descPassthrough>>", exceptionClass, 7, 3).build();
        ControlsInjectionUtil.setControls(session, controls);
        QueryContext context = new QueryContext(session, bits[0].getContext());
        DummyClass dummyClass = new DummyClass(context);
        for (i = 0; i < 7; ++i) {
            dummyClass.descPassthroughMethod("<<injected from descPassthrough>>");
        }
        for (i = 0; i < 3; ++i) {
            TestExceptionInjection.assertPassthroughThrows(dummyClass, exceptionClass.getName(), "<<injected from descPassthrough>>");
        }
        dummyClass.descPassthroughMethod("<<injected from descPassthrough>>");
        try {
            context.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void injectionOnSpecificBit() {
        int i;
        int i2;
        Drillbit drillbit2;
        Drillbit drillbit1;
        RemoteServiceSet remoteServiceSet = RemoteServiceSet.getLocalServiceSet();
        ZookeeperHelper zkHelper = new ZookeeperHelper();
        zkHelper.startZookeeper(1);
        DrillConfig drillConfig = zkHelper.getConfig();
        try {
            drillbit1 = Drillbit.start((DrillConfig)drillConfig, (RemoteServiceSet)remoteServiceSet);
            drillbit2 = Drillbit.start((DrillConfig)drillConfig, (RemoteServiceSet)remoteServiceSet);
        }
        catch (DrillbitStartupException e) {
            throw new RuntimeException("Failed to start drillbits.", e);
        }
        DrillbitContext drillbitContext1 = drillbit1.getContext();
        DrillbitContext drillbitContext2 = drillbit2.getContext();
        UserSession session = UserSession.Builder.newBuilder().withCredentials(UserBitShared.UserCredentials.newBuilder().setUserName("foo").build()).withUserProperties(UserProtos.UserProperties.getDefaultInstance()).withOptionManager((OptionManager)drillbitContext1.getOptionManager()).build();
        String passthroughDesc = "<<injected from descPassthrough>>";
        int nSkip = 7;
        int nFire = 3;
        Class<RuntimeException> exceptionClass = RuntimeException.class;
        String controls = Controls.newBuilder().addExceptionOnBit(DummyClass.class, "<<injected from descPassthrough>>", exceptionClass, drillbitContext1.getEndpoint(), 7, 3).build();
        ControlsInjectionUtil.setControls(session, controls);
        QueryContext queryContext1 = new QueryContext(session, drillbitContext1);
        DummyClass class1 = new DummyClass(queryContext1);
        for (i2 = 0; i2 < 7; ++i2) {
            class1.descPassthroughMethod("<<injected from descPassthrough>>");
        }
        for (i2 = 0; i2 < 3; ++i2) {
            TestExceptionInjection.assertPassthroughThrows(class1, exceptionClass.getName(), "<<injected from descPassthrough>>");
        }
        class1.descPassthroughMethod("<<injected from descPassthrough>>");
        try {
            queryContext1.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        QueryContext queryContext2 = new QueryContext(session, drillbitContext2);
        DummyClass class2 = new DummyClass(queryContext2);
        for (i = 0; i < 7; ++i) {
            class2.descPassthroughMethod("<<injected from descPassthrough>>");
        }
        for (i = 0; i < 3; ++i) {
            class2.descPassthroughMethod("<<injected from descPassthrough>>");
        }
        class2.descPassthroughMethod("<<injected from descPassthrough>>");
        try {
            queryContext2.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    private static class DummyClass {
        private static final ControlsInjector injector = ControlsInjectorFactory.getInjector(DummyClass.class);
        private final QueryContext context;
        public static final String THROWS_IOEXCEPTION = "<<throwsIOException>>";

        public DummyClass(QueryContext context) {
            this.context = context;
        }

        public void descPassthroughMethod(String desc) {
            injector.injectUnchecked(this.context.getExecutionControls(), desc);
        }

        public void throwsIOException() throws IOException {
            injector.injectChecked(this.context.getExecutionControls(), THROWS_IOEXCEPTION, IOException.class);
        }
    }
}

