/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.testing;

import java.util.concurrent.CountDownLatch;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.concurrent.ExtendedLatch;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.testing.Controls;
import org.apache.drill.exec.testing.ControlsInjectionUtil;
import org.apache.drill.exec.testing.ControlsInjector;
import org.apache.drill.exec.testing.ControlsInjectorFactory;
import org.apache.drill.exec.util.Pointer;
import org.junit.Assert;
import org.junit.Test;

public class TestCountDownLatchInjection
extends BaseTestQuery {
    private static final UserSession session = UserSession.Builder.newBuilder().withCredentials(UserBitShared.UserCredentials.newBuilder().setUserName("foo").build()).withUserProperties(UserProtos.UserProperties.getDefaultInstance()).withOptionManager((OptionManager)bits[0].getContext().getOptionManager()).build();

    @Test
    public void latchInjected() {
        long timeSpentWaiting;
        int threads = 10;
        ExtendedLatch trigger = new ExtendedLatch(1);
        Pointer countingDownTime = new Pointer();
        String controls = Controls.newBuilder().addLatch(DummyClass.class, "<<latch>>").build();
        ControlsInjectionUtil.setControls(session, controls);
        QueryContext queryContext = new QueryContext(session, bits[0].getContext());
        DummyClass dummyClass = new DummyClass(queryContext, (CountDownLatch)trigger, 10);
        new ThreadCreator(dummyClass, trigger, 10, (Pointer<Long>)countingDownTime).start();
        try {
            timeSpentWaiting = dummyClass.initAndWait();
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Thread should not be interrupted; there is no deliberate attempt.");
            return;
        }
        Assert.assertTrue((timeSpentWaiting >= (Long)countingDownTime.value ? 1 : 0) != 0);
        try {
            queryContext.close();
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to close query context: " + e));
        }
    }

    private static class ThreadCreator
    extends Thread {
        private final DummyClass dummyClass;
        private final ExtendedLatch latch;
        private final int count;
        private final Pointer<Long> countingDownTime;

        public ThreadCreator(DummyClass dummyClass, ExtendedLatch latch, int count, Pointer<Long> countingDownTime) {
            this.dummyClass = dummyClass;
            this.latch = latch;
            this.count = count;
            this.countingDownTime = countingDownTime;
        }

        @Override
        public void run() {
            this.latch.awaitUninterruptibly();
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < this.count; ++i) {
                new Thread(){

                    @Override
                    public void run() {
                        ThreadCreator.this.dummyClass.countDown();
                    }
                }.start();
            }
            long endTime = System.currentTimeMillis();
            this.countingDownTime.value = endTime - startTime;
        }
    }

    private static class DummyClass {
        private static final ControlsInjector injector = ControlsInjectorFactory.getInjector(DummyClass.class);
        private final QueryContext context;
        private final CountDownLatch latch;
        private final int count;
        public static final String LATCH_NAME = "<<latch>>";

        public DummyClass(QueryContext context, CountDownLatch latch, int count) {
            this.context = context;
            this.latch = latch;
            this.count = count;
        }

        public long initAndWait() throws InterruptedException {
            injector.getLatch(this.context.getExecutionControls(), LATCH_NAME).initialize(this.count);
            this.latch.countDown();
            long startTime = System.currentTimeMillis();
            injector.getLatch(this.context.getExecutionControls(), LATCH_NAME).await();
            long endTime = System.currentTimeMillis();
            return endTime - startTime;
        }

        public void countDown() {
            injector.getLatch(this.context.getExecutionControls(), LATCH_NAME).countDown();
        }
    }
}

