/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.testing;

import java.util.List;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.testing.ExecutionControls;
import org.junit.Assert;

public class ControlsInjectionUtil {
    private static final UserSession.QueryCountIncrementer incrementer = new UserSession.QueryCountIncrementer(){

        public void increment(UserSession session) {
            session.incrementQueryCount((UserSession.QueryCountIncrementer)this);
        }
    };

    private ControlsInjectionUtil() {
    }

    public static void setSessionOption(DrillClient drillClient, String option, String value) {
        try {
            List results = drillClient.runQuery(UserBitShared.QueryType.SQL, String.format("ALTER session SET `%s` = %s", option, value));
            for (QueryDataBatch data : results) {
                data.release();
            }
        }
        catch (RpcException e) {
            Assert.fail((String)("Could not set option: " + e.toString()));
        }
    }

    public static void setControls(DrillClient drillClient, String controls) {
        ControlsInjectionUtil.validateControlsString(controls);
        ControlsInjectionUtil.setSessionOption(drillClient, "drill.exec.testing.controls", "'" + controls + "'");
    }

    public static void setControls(UserSession session, String controls) {
        ControlsInjectionUtil.validateControlsString(controls);
        OptionValue opValue = OptionValue.createString((OptionValue.OptionType)OptionValue.OptionType.SESSION, (String)"drill.exec.testing.controls", (String)controls);
        OptionManager options = session.getOptions();
        try {
            ExecConstants.DRILLBIT_CONTROLS_VALIDATOR.validate(opValue);
            options.setOption(opValue);
        }
        catch (Exception e) {
            Assert.fail((String)("Could not set controls options: " + e.getMessage()));
        }
        incrementer.increment(session);
    }

    public static void validateControlsString(String controls) {
        try {
            ExecutionControls.validateControlsString((String)controls);
        }
        catch (Exception e) {
            Assert.fail((String)("Could not validate controls JSON: " + e.getMessage()));
        }
    }

    public static String createException(Class<?> siteClass, String desc, int nSkip, int nFire, Class<? extends Throwable> exceptionClass) {
        String siteClassName = siteClass.getName();
        String exceptionClassName = exceptionClass.getName();
        return "{ \"type\":\"exception\",\"siteClass\":\"" + siteClassName + "\"," + "\"desc\":\"" + desc + "\"," + "\"nSkip\":" + nSkip + "," + "\"nFire\":" + nFire + "," + "\"exceptionClass\":\"" + exceptionClassName + "\"}";
    }

    public static String createExceptionOnBit(Class<?> siteClass, String desc, int nSkip, int nFire, Class<? extends Throwable> exceptionClass, CoordinationProtos.DrillbitEndpoint endpoint) {
        String siteClassName = siteClass.getName();
        String exceptionClassName = exceptionClass.getName();
        return "{ \"type\":\"exception\",\"siteClass\":\"" + siteClassName + "\"," + "\"desc\":\"" + desc + "\"," + "\"nSkip\":" + nSkip + "," + "\"nFire\":" + nFire + "," + "\"exceptionClass\":\"" + exceptionClassName + "\"," + "\"address\":\"" + endpoint.getAddress() + "\"," + "\"port\":\"" + endpoint.getUserPort() + "\"}";
    }

    public static String createPause(Class siteClass, String desc, int nSkip) {
        return "{ \"type\" : \"pause\",\"siteClass\" : \"" + siteClass.getName() + "\"," + "\"desc\" : \"" + desc + "\"," + "\"nSkip\" : " + nSkip + "}";
    }

    public static String createPauseOnBit(Class siteClass, String desc, int nSkip, CoordinationProtos.DrillbitEndpoint endpoint) {
        return "{ \"type\" : \"pause\",\"siteClass\" : \"" + siteClass.getName() + "\"," + "\"desc\" : \"" + desc + "\"," + "\"nSkip\" : " + nSkip + "," + "\"address\":\"" + endpoint.getAddress() + "\"," + "\"port\":\"" + endpoint.getUserPort() + "\"}";
    }

    public static String createLatch(Class siteClass, String desc) {
        return "{ \"type\":\"latch\",\"siteClass\":\"" + siteClass.getName() + "\"," + "\"desc\":\"" + desc + "\"}";
    }

    public static void clearControls(DrillClient client) {
        ControlsInjectionUtil.setControls(client, "{}");
    }
}

