/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.testing;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.testing.ControlsInjectionUtil;

public class Controls {
    private static final String EMPTY_CONTROLS = "{\"injections\" : []}";

    public static Builder newBuilder() {
        return new Builder();
    }

    private Controls() {
    }

    public static class Builder {
        private final List<String> injections = Lists.newArrayList();

        public Builder addException(Class<?> siteClass, String desc, Class<? extends Throwable> exceptionClass, int nSkip, int nFire) {
            this.injections.add(ControlsInjectionUtil.createException(siteClass, desc, nSkip, nFire, exceptionClass));
            return this;
        }

        public Builder addException(Class<?> siteClass, String desc, Class<? extends Throwable> exceptionClass) {
            return this.addException(siteClass, desc, exceptionClass, 0, 1);
        }

        public Builder addExceptionOnBit(Class<?> siteClass, String desc, Class<? extends Throwable> exceptionClass, CoordinationProtos.DrillbitEndpoint endpoint, int nSkip, int nFire) {
            this.injections.add(ControlsInjectionUtil.createExceptionOnBit(siteClass, desc, nSkip, nFire, exceptionClass, endpoint));
            return this;
        }

        public Builder addExceptionOnBit(Class<?> siteClass, String desc, Class<? extends Throwable> exceptionClass, CoordinationProtos.DrillbitEndpoint endpoint) {
            return this.addExceptionOnBit(siteClass, desc, exceptionClass, endpoint, 0, 1);
        }

        public Builder addPause(Class siteClass, String desc, int nSkip) {
            this.injections.add(ControlsInjectionUtil.createPause(siteClass, desc, nSkip));
            return this;
        }

        public Builder addPause(Class siteClass, String desc) {
            return this.addPause(siteClass, desc, 0);
        }

        public Builder addPauseOnBit(Class siteClass, String desc, CoordinationProtos.DrillbitEndpoint endpoint, int nSkip) {
            this.injections.add(ControlsInjectionUtil.createPauseOnBit(siteClass, desc, nSkip, endpoint));
            return this;
        }

        public Builder addPauseOnBit(Class siteClass, String desc, CoordinationProtos.DrillbitEndpoint endpoint) {
            return this.addPauseOnBit(siteClass, desc, endpoint, 0);
        }

        public Builder addLatch(Class siteClass, String desc) {
            this.injections.add(ControlsInjectionUtil.createLatch(siteClass, desc));
            return this;
        }

        public String build() {
            if (this.injections.size() == 0) {
                return Controls.EMPTY_CONTROLS;
            }
            StringBuilder builder = new StringBuilder("{ \"injections\" : [");
            for (String injection : this.injections) {
                builder.append(injection).append(",");
            }
            builder.setLength(builder.length() - 1);
            builder.append("]}");
            String controls = builder.toString();
            ControlsInjectionUtil.validateControlsString(controls);
            return controls;
        }
    }
}

