/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.text;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.util.VectorUtil;
import org.junit.Assert;
import org.junit.Test;

public class TextRecordReaderTest
extends PopUnitTestBase {
    @Test
    public void testFullExecution() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/store/text/test.json"), (Charset)Charsets.UTF_8).replace("#{DATA_FILE}", FileUtils.getResourceAsFile((String)"/store/text/data/regions.csv").toURI().toString()));
            int count = 0;
            RecordBatchLoader loader = new RecordBatchLoader(bit1.getContext().getAllocator());
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                loader.load(b.getHeader().getDef(), b.getData());
                VectorUtil.showVectorAccessibleContent((VectorAccessible)loader);
                loader.clear();
                b.release();
            }
            Assert.assertEquals((long)5L, (long)count);
        }
    }
}

