/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTextColumn
extends BaseTestQuery {
    static final Logger logger = LoggerFactory.getLogger(TestTextColumn.class);

    @Test
    public void testCsvColumnSelection() throws Exception {
        TestTextColumn.test("select columns[0] as region_id, columns[1] as country from dfs_test.`[WORKING_PATH]/src/test/resources/store/text/data/regions.csv`");
    }

    @Test
    public void testDefaultDelimiterColumnSelection() throws Exception {
        List<QueryDataBatch> batches = TestTextColumn.testSqlWithResults("SELECT columns[0] as entire_row from dfs_test.`[WORKING_PATH]/src/test/resources/store/text/data/letters.txt`");
        List<List<String>> expectedOutput = Arrays.asList(Arrays.asList("a, b,\",\"c\",\"d,, \\n e"), Arrays.asList("d, e,\",\"f\",\"g,, \\n h"), Arrays.asList("g, h,\",\"i\",\"j,, \\n k"));
        List<List<String>> actualOutput = this.getOutput(batches);
        System.out.println(actualOutput);
        this.validateOutput(expectedOutput, actualOutput);
    }

    @Test
    public void testCsvColumnSelectionCommasInsideQuotes() throws Exception {
        List<QueryDataBatch> batches = TestTextColumn.testSqlWithResults("SELECT columns[0] as col1, columns[1] as col2, columns[2] as col3,columns[3] as col4 from dfs_test.`[WORKING_PATH]/src/test/resources/store/text/data/letters.csv`");
        List<List<String>> expectedOutput = Arrays.asList(Arrays.asList("a, b,", "c", "d,, \\n e", "f\\\"g"), Arrays.asList("d, e,", "f", "g,, \\n h", "i\\\"j"), Arrays.asList("g, h,", "i", "j,, \\n k", "l\\\"m"));
        List<List<String>> actualOutput = this.getOutput(batches);
        this.validateOutput(expectedOutput, actualOutput);
    }

    private List<List<String>> getOutput(List<QueryDataBatch> batches) throws SchemaChangeException {
        ArrayList<List<String>> output = new ArrayList<List<String>>();
        RecordBatchLoader loader = new RecordBatchLoader(TestTextColumn.getAllocator());
        int last = 0;
        for (QueryDataBatch batch : batches) {
            int rows = batch.getHeader().getRowCount();
            if (batch.getData() != null) {
                loader.load(batch.getHeader().getDef(), batch.getData());
                for (int i = 0; i < rows; ++i) {
                    output.add(new ArrayList());
                    for (VectorWrapper vw : loader) {
                        ValueVector.Accessor accessor = vw.getValueVector().getAccessor();
                        Object o = accessor.getObject(i);
                        ((List)output.get(last)).add(o == null ? null : o.toString());
                    }
                    ++last;
                }
            }
            loader.clear();
            batch.release();
        }
        return output;
    }

    private void validateOutput(List<List<String>> expected, List<List<String>> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((long)expected.get(i).size(), (long)actual.get(i).size());
            for (int j = 0; j < expected.get(i).size(); ++j) {
                Assert.assertEquals((Object)expected.get(i).get(j), (Object)actual.get(i).get(j));
            }
        }
    }
}

