/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.text;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.proto.UserBitShared;
import org.junit.Assert;
import org.junit.Test;

public class TestNewTextReader
extends BaseTestQuery {
    @Test
    public void fieldDelimiterWithinQuotes() throws Exception {
        TestNewTextReader.testBuilder().sqlQuery("select columns[1] as col1 from cp.`textinput/input1.csv`").unOrdered().baselineColumns("col1").baselineValues("foo,bar").go();
    }

    @Test
    public void ensureFailureOnNewLineDelimiterWithinQuotes() {
        try {
            TestNewTextReader.test("select columns[1] as col1 from cp.`textinput/input2.csv`");
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot use newline character within quoted string"));
        }
    }

    @Test
    public void ensureColumnNameDisplayedinError() throws Exception {
        String COL_NAME = "col1";
        try {
            TestNewTextReader.test("select max(columns[1]) as %s from cp.`textinput/input1.csv` where %s is not null", "col1", "col1");
            Assert.fail((String)"Query should have failed");
        }
        catch (UserRemoteException ex) {
            Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.DATA_READ, (Object)ex.getErrorType());
            Assert.assertTrue((String)"Error message should contain col1", (boolean)ex.getMessage().contains("col1"));
        }
    }

    @Test
    public void testTabSeparatedWithQuote() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/WithQuote.tsv").toURI().toString();
        String query = String.format("select columns[0] as c0, columns[1] as c1, columns[2] as c2 \nfrom dfs_test.`%s` ", root);
        TestNewTextReader.testBuilder().sqlQuery(query).unOrdered().baselineColumns("c0", "c1", "c2").baselineValues("a", "a", "a").baselineValues("a", "a", "a").baselineValues("a", "a", "a").build().run();
    }

    @Test
    public void testSpaceSeparatedWithQuote() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/WithQuote.ssv").toURI().toString();
        String query = String.format("select columns[0] as c0, columns[1] as c1, columns[2] as c2 \nfrom dfs_test.`%s` ", root);
        TestNewTextReader.testBuilder().sqlQuery(query).unOrdered().baselineColumns("c0", "c1", "c2").baselineValues("a", "a", "a").baselineValues("a", "a", "a").baselineValues("a", "a", "a").build().run();
    }

    @Test
    public void testPipSeparatedWithQuote() throws Exception {
        String root = FileUtils.getResourceAsFile((String)"/store/text/WithQuote.tbl").toURI().toString();
        String query = String.format("select columns[0] as c0, columns[1] as c1, columns[2] as c2 \nfrom dfs_test.`%s` ", root);
        TestNewTextReader.testBuilder().sqlQuery(query).unOrdered().baselineColumns("c0", "c1", "c2").baselineValues("a", "a", "a").baselineValues("a", "a", "a").baselineValues("a", "a", "a").build().run();
    }
}

