/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.TestWithZookeeper;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.store.sys.PStoreTestUtil;
import org.apache.drill.exec.store.sys.local.LocalPStoreProvider;
import org.apache.drill.exec.store.sys.zk.ZkPStoreProvider;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPStoreProviders
extends TestWithZookeeper {
    static final Logger logger = LoggerFactory.getLogger(TestPStoreProviders.class);
    static LocalPStoreProvider provider;

    @Test
    public void verifyLocalStore() throws Exception {
        try (LocalPStoreProvider provider = new LocalPStoreProvider(DrillConfig.create());){
            PStoreTestUtil.test((PStoreProvider)provider);
        }
    }

    @Test
    public void verifyZkStore() throws Exception {
        DrillConfig config = TestPStoreProviders.getConfig();
        String connect = config.getString("drill.exec.zk.connect");
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().namespace(config.getString("drill.exec.zk.root")).retryPolicy((RetryPolicy)new RetryNTimes(1, 100)).connectionTimeoutMs(config.getInt("drill.exec.zk.timeout")).connectString(connect);
        try (CuratorFramework curator = builder.build();){
            curator.start();
            ZkPStoreProvider provider = new ZkPStoreProvider(config, curator);
            PStoreTestUtil.test((PStoreProvider)provider);
        }
    }
}

