/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PStoreTestUtil {
    static final Logger logger = LoggerFactory.getLogger(PStoreTestUtil.class);

    public static void test(PStoreProvider provider) throws Exception {
        PStore store = provider.getStore(PStoreConfig.newJacksonBuilder((ObjectMapper)new ObjectMapper(), String.class).name("sys.test").build());
        String[] keys = new String[]{"first", "second"};
        String[] values = new String[]{"value1", "value2"};
        HashMap expectedMap = Maps.newHashMap();
        for (int i = 0; i < keys.length; ++i) {
            expectedMap.put(keys[i], values[i]);
            store.put(keys[i], (Object)values[i]);
        }
        Iterator iter = store.iterator();
        for (int i = 0; i < keys.length; ++i) {
            Map.Entry e = (Map.Entry)iter.next();
            Assert.assertTrue((boolean)expectedMap.containsKey(e.getKey()));
            Assert.assertEquals(expectedMap.get(e.getKey()), e.getValue());
        }
        Assert.assertFalse((boolean)iter.hasNext());
        iter = store.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        Assert.assertFalse((boolean)store.iterator().hasNext());
    }
}

