/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.store;

import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.schedule.AssignmentCreator;
import org.apache.drill.exec.store.schedule.CompleteFileWork;
import org.apache.drill.exec.store.schedule.EndpointByteMap;
import org.apache.drill.exec.store.schedule.EndpointByteMapImpl;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAssignment {
    private static final long FILE_SIZE = 1000L;
    private static List<CoordinationProtos.DrillbitEndpoint> endpoints;

    @BeforeClass
    public static void setup() {
        endpoints = Lists.newArrayList();
        String pattern = "node%d";
        for (int i = 2; i < 32; ++i) {
            String host = String.format("node%d", i);
            endpoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress(host).build());
        }
    }

    @Test
    public void manyFiles() throws Exception {
        List<CompleteFileWork> chunks = this.generateChunks(1000);
        Iterator incomingEndpointsIterator = Iterators.cycle(endpoints);
        ArrayList incomingEndpoints = Lists.newArrayList();
        int width = 840;
        for (int i = 0; i < 840; ++i) {
            incomingEndpoints.add(incomingEndpointsIterator.next());
        }
        ListMultimap mappings = AssignmentCreator.getMappings((List)incomingEndpoints, chunks, null);
        System.out.println(mappings.keySet().size());
        for (int i = 0; i < 840; ++i) {
            Assert.assertTrue((String)("no mapping for entry " + i), (mappings.get((Object)i) != null && mappings.get((Object)i).size() > 0 ? 1 : 0) != 0);
        }
    }

    private List<CompleteFileWork> generateChunks(int chunks) {
        ArrayList chunkList = Lists.newArrayList();
        for (int i = 0; i < chunks; ++i) {
            CompleteFileWork chunk = new CompleteFileWork(this.createByteMap(), 0L, 1000L, "file" + i);
            chunkList.add(chunk);
        }
        return chunkList;
    }

    private EndpointByteMap createByteMap() {
        EndpointByteMapImpl endpointByteMap = new EndpointByteMapImpl();
        HashSet usedEndpoints = Sets.newHashSet();
        while (usedEndpoints.size() < 3) {
            usedEndpoints.add(this.getRandom(endpoints));
        }
        for (CoordinationProtos.DrillbitEndpoint ep : usedEndpoints) {
            endpointByteMap.add(ep, 1000L);
        }
        return endpointByteMap;
    }

    private <T> T getRandom(List<T> list) {
        int index = ThreadLocalRandom.current().nextInt(list.size());
        return list.get(index);
    }
}

