/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet2;

import java.math.BigDecimal;
import org.apache.drill.BaseTestQuery;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDrillParquetReader
extends BaseTestQuery {
    @BeforeClass
    public static void enableDecimalDataType() throws Exception {
        TestDrillParquetReader.test(String.format("alter session set `%s` = true", "planner.enable_decimal_data_type"));
    }

    @AfterClass
    public static void disableDecimalDataType() throws Exception {
        TestDrillParquetReader.test(String.format("alter session set `%s` = false", "planner.enable_decimal_data_type"));
    }

    private void testColumn(String columnName) throws Exception {
        TestDrillParquetReader.testNoResult("alter session set `store.parquet.use_new_reader` = true", new Object[0]);
        BigDecimal result = new BigDecimal("1.20000000");
        TestDrillParquetReader.testBuilder().ordered().sqlQuery("select %s from cp.`parquet2/decimal28_38.parquet`", columnName).baselineColumns(columnName).baselineValues(result).go();
        TestDrillParquetReader.testNoResult("alter session set `store.parquet.use_new_reader` = false", new Object[0]);
    }

    @Test
    public void testRequiredDecimal28() throws Exception {
        this.testColumn("d28_req");
    }

    @Test
    public void testRequiredDecimal38() throws Exception {
        this.testColumn("d38_req");
    }

    @Test
    public void testOptionalDecimal28() throws Exception {
        this.testColumn("d28_opt");
    }

    @Test
    public void testOptionalDecimal38() throws Exception {
        this.testColumn("d38_opt");
    }
}

