/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import org.apache.drill.BaseTestQuery;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestColumnReaderFactory
extends BaseTestQuery {
    @BeforeClass
    public static void enableDecimalDataType() throws Exception {
        TestColumnReaderFactory.test(String.format("alter session set `%s` = true", "planner.enable_decimal_data_type"));
    }

    @AfterClass
    public static void disableDecimalDataType() throws Exception {
        TestColumnReaderFactory.test(String.format("alter session set `%s` = false", "planner.enable_decimal_data_type"));
    }

    @Test
    public void testTimeAndTimeStampWithDictionary() throws Exception {
        TestColumnReaderFactory.testNoResult("SELECT * FROM cp.`parquet/time_dictionary.parquet`", new Object[0]);
    }

    @Test
    public void testTimeAndTimeStampWithNoDictionary() throws Exception {
        TestColumnReaderFactory.testNoResult("SELECT * FROM cp.`parquet/time_nodictionary.parquet`", new Object[0]);
    }

    @Test
    public void testDecimal9AndDecimal18WithDictionary() throws Exception {
        TestColumnReaderFactory.testNoResult("SELECT * FROM cp.`parquet/decimal_dictionary.parquet`", new Object[0]);
    }

    @Test
    public void testDecimal9AndDecimal18WithNoDictionary() throws Exception {
        TestColumnReaderFactory.testNoResult("SELECT * FROM cp.`parquet/decimal_nodictionary.parquet`", new Object[0]);
    }
}

