/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.google.common.io.Resources;
import java.net.URL;
import org.apache.drill.BaseTestQuery;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestParquetScan
extends BaseTestQuery {
    static FileSystem fs;

    @BeforeClass
    public static void initFs() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "local");
        fs = FileSystem.get((Configuration)conf);
    }

    @Test
    public void testSuccessFile() throws Exception {
        Path p = new Path("/tmp/nation_test_parquet_scan");
        if (fs.exists(p)) {
            fs.delete(p, true);
        }
        fs.mkdirs(p);
        byte[] bytes = Resources.toByteArray((URL)Resources.getResource((String)"tpch/nation.parquet"));
        FSDataOutputStream os = fs.create(new Path(p, "nation.parquet"));
        os.write(bytes);
        os.close();
        fs.create(new Path(p, "_SUCCESS")).close();
        fs.create(new Path(p, "_logs")).close();
        TestParquetScan.testBuilder().sqlQuery("select count(*) c from dfs.tmp.nation_test_parquet_scan where 1 = 1").unOrdered().baselineColumns("c").baselineValues(25L).build().run();
    }
}

