/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestParquetPhysicalPlan
extends ExecTest {
    private static final Logger logger = LoggerFactory.getLogger(TestParquetPhysicalPlan.class);
    public String fileName = "parquet/parquet_scan_filter_union_screen_physical.json";

    @Test
    @Ignore
    public void testParseParquetPhysicalPlan() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        DrillConfig config = DrillConfig.create();
        try (Drillbit bit1 = new Drillbit(config, serviceSet);
             DrillClient client = new DrillClient(config, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Resources.toString((URL)Resources.getResource((String)this.fileName), (Charset)Charsets.UTF_8));
            RecordBatchLoader loader = new RecordBatchLoader(bit1.getContext().getAllocator());
            int count = 0;
            for (QueryDataBatch b : results) {
                System.out.println(String.format("Got %d results", b.getHeader().getRowCount()));
                count += b.getHeader().getRowCount();
                loader.load(b.getHeader().getDef(), b.getData());
                for (VectorWrapper vw : loader) {
                    System.out.print(vw.getValueVector().getField().toExpr() + ": ");
                    ValueVector vv = vw.getValueVector();
                    for (int i = 0; i < vv.getAccessor().getValueCount(); ++i) {
                        Object o = vv.getAccessor().getObject(i);
                        if (o instanceof byte[]) {
                            System.out.print(" [" + new String((byte[])o) + "]");
                            continue;
                        }
                        System.out.print(" [" + vv.getAccessor().getObject(i) + "]");
                    }
                    System.out.println();
                }
                loader.clear();
                b.release();
            }
            client.close();
            System.out.println(String.format("Got %d total results", count));
        }
    }

    @Test
    @Ignore
    public void testParseParquetPhysicalPlanRemote() throws Exception {
        DrillConfig config = DrillConfig.create();
        try (DrillClient client = new DrillClient(config);){
            client.connect();
            ParquetResultsListener listener = new ParquetResultsListener();
            Stopwatch watch = new Stopwatch();
            watch.start();
            client.runQuery(UserBitShared.QueryType.PHYSICAL, Resources.toString((URL)Resources.getResource((String)this.fileName), (Charset)Charsets.UTF_8), (UserResultsListener)listener);
            System.out.println(String.format("Got %d total records in %d seconds", listener.await(), watch.elapsed(TimeUnit.SECONDS)));
            client.close();
        }
    }

    private class ParquetResultsListener
    implements UserResultsListener {
        AtomicInteger count = new AtomicInteger();
        private CountDownLatch latch = new CountDownLatch(1);

        private ParquetResultsListener() {
        }

        public void submissionFailed(UserException ex) {
            logger.error("submission failed", (Throwable)ex);
            this.latch.countDown();
        }

        public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
            this.latch.countDown();
        }

        public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
            int rows = result.getHeader().getRowCount();
            System.out.println(String.format("Result batch arrived. Number of records: %d", rows));
            this.count.addAndGet(rows);
            result.release();
        }

        public int await() throws Exception {
            this.latch.await();
            return this.count.get();
        }

        public void queryIdArrived(UserBitShared.QueryId queryId) {
        }
    }
}

