/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.google.common.base.Joiner;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.commons.io.FileUtils;
import org.apache.drill.PlanTestBase;
import org.apache.drill.common.util.TestTools;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestParquetMetadataCache
extends PlanTestBase {
    private static final String WORKING_PATH = TestTools.getWorkingPath();
    private static final String TEST_RES_PATH = WORKING_PATH + "/src/test/resources";
    private static final String tableName = "parquetTable";

    @BeforeClass
    public static void copyData() throws Exception {
        String tmpLocation = TestParquetMetadataCache.getDfsTestTmpSchemaLocation();
        File dataDir = new File(tmpLocation + "/" + tableName);
        dataDir.mkdir();
        FileUtils.copyDirectory((File)new File(String.format(String.format("%s/multilevel/parquet", TEST_RES_PATH), new Object[0])), (File)dataDir);
    }

    @Test
    public void testPartitionPruningWithMetadataCache_1() throws Exception {
        TestParquetMetadataCache.test(String.format("refresh table metadata dfs_test.`%s/%s`", TestParquetMetadataCache.getDfsTestTmpSchemaLocation(), tableName));
        this.checkForMetadataFile(tableName);
        String query = String.format("select dir0, dir1, o_custkey, o_orderdate from dfs_test.`%s/%s`  where dir0=1994 and dir1='Q1'", TestParquetMetadataCache.getDfsTestTmpSchemaLocation(), tableName);
        int expectedRowCount = 10;
        int expectedNumFiles = 1;
        int actualRowCount = TestParquetMetadataCache.testSql(query);
        Assert.assertEquals((long)expectedRowCount, (long)actualRowCount);
        String numFilesPattern = "numFiles=" + expectedNumFiles;
        String usedMetaPattern = "usedMetadataFile=true";
        PlanTestBase.testPlanMatchingPatterns(query, new String[]{numFilesPattern, usedMetaPattern}, new String[]{"Filter"});
    }

    @Test
    public void testPartitionPruningWithMetadataCache_2() throws Exception {
        TestParquetMetadataCache.test(String.format("refresh table metadata dfs_test.`%s/%s`", TestParquetMetadataCache.getDfsTestTmpSchemaLocation(), tableName));
        this.checkForMetadataFile(tableName);
        String query = String.format("select dir0, dir1, o_custkey, o_orderdate from dfs_test.`%s/%s`  where dir0=1994", TestParquetMetadataCache.getDfsTestTmpSchemaLocation(), tableName);
        int expectedRowCount = 40;
        int expectedNumFiles = 4;
        int actualRowCount = TestParquetMetadataCache.testSql(query);
        Assert.assertEquals((long)expectedRowCount, (long)actualRowCount);
        String numFilesPattern = "numFiles=" + expectedNumFiles;
        String usedMetaPattern = "usedMetadataFile=true";
        PlanTestBase.testPlanMatchingPatterns(query, new String[]{numFilesPattern, usedMetaPattern}, new String[]{"Filter"});
    }

    @Test
    public void testPartitionPruningWithMetadataCache_3() throws Exception {
        String tableName = "orders_ctas_varchar";
        TestParquetMetadataCache.test("use dfs_test.tmp");
        TestParquetMetadataCache.test(String.format("create table %s (o_orderdate, o_orderpriority) partition by (o_orderpriority) as select o_orderdate, o_orderpriority from dfs_test.`%s/multilevel/parquet/1994/Q1`", tableName, TEST_RES_PATH));
        TestParquetMetadataCache.test(String.format("refresh table metadata %s", tableName));
        this.checkForMetadataFile(tableName);
        String query = String.format("select * from %s where o_orderpriority = '1-URGENT'", tableName);
        int expectedRowCount = 3;
        int expectedNumFiles = 1;
        int actualRowCount = TestParquetMetadataCache.testSql(query);
        Assert.assertEquals((long)expectedRowCount, (long)actualRowCount);
        String numFilesPattern = "numFiles=" + expectedNumFiles;
        String usedMetaPattern = "usedMetadataFile=true";
        TestParquetMetadataCache.testPlanMatchingPatterns(query, new String[]{numFilesPattern, usedMetaPattern}, new String[0]);
    }

    @Test
    public void testPartitionPruningWithMetadataCache_4() throws Exception {
        String tableName = "orders_ctas_binary";
        TestParquetMetadataCache.test("use dfs_test.tmp");
        TestParquetMetadataCache.test(String.format("create table %s (o_orderdate, o_orderpriority) partition by (o_orderpriority) as select o_orderdate, convert_to(o_orderpriority, 'UTF8') as o_orderpriority from dfs_test.`%s/multilevel/parquet/1994/Q1`", tableName, TEST_RES_PATH));
        TestParquetMetadataCache.test(String.format("refresh table metadata %s", tableName));
        this.checkForMetadataFile(tableName);
        String query = String.format("select * from %s where o_orderpriority = '1-URGENT'", tableName);
        int expectedRowCount = 3;
        int expectedNumFiles = 1;
        int actualRowCount = TestParquetMetadataCache.testSql(query);
        Assert.assertEquals((long)expectedRowCount, (long)actualRowCount);
        String numFilesPattern = "numFiles=" + expectedNumFiles;
        String usedMetaPattern = "usedMetadataFile=true";
        TestParquetMetadataCache.testPlanMatchingPatterns(query, new String[]{numFilesPattern, usedMetaPattern}, new String[0]);
    }

    @Test
    public void testCache() throws Exception {
        String tableName = "nation_ctas";
        TestParquetMetadataCache.test("use dfs_test.tmp");
        TestParquetMetadataCache.test(String.format("create table `%s/t1` as select * from cp.`tpch/nation.parquet`", tableName));
        TestParquetMetadataCache.test(String.format("create table `%s/t2` as select * from cp.`tpch/nation.parquet`", tableName));
        TestParquetMetadataCache.test(String.format("refresh table metadata %s", tableName));
        this.checkForMetadataFile(tableName);
        String query = String.format("select * from %s", tableName);
        int rowCount = TestParquetMetadataCache.testSql(query);
        Assert.assertEquals((long)50L, (long)rowCount);
        TestParquetMetadataCache.testPlanMatchingPatterns(query, new String[]{"usedMetadataFile=true"}, new String[0]);
    }

    @Test
    public void testUpdate() throws Exception {
        String tableName = "nation_ctas_update";
        TestParquetMetadataCache.test("use dfs_test.tmp");
        TestParquetMetadataCache.test(String.format("create table `%s/t1` as select * from cp.`tpch/nation.parquet`", tableName));
        TestParquetMetadataCache.test(String.format("refresh table metadata %s", tableName));
        this.checkForMetadataFile(tableName);
        Thread.sleep(1000L);
        TestParquetMetadataCache.test(String.format("create table `%s/t2` as select * from cp.`tpch/nation.parquet`", tableName));
        int rowCount = TestParquetMetadataCache.testSql(String.format("select * from %s", tableName));
        Assert.assertEquals((long)50L, (long)rowCount);
    }

    @Test
    public void testCacheWithSubschema() throws Exception {
        String tableName = "nation_ctas_subschema";
        TestParquetMetadataCache.test(String.format("create table dfs_test.tmp.`%s/t1` as select * from cp.`tpch/nation.parquet`", tableName));
        TestParquetMetadataCache.test(String.format("refresh table metadata dfs_test.tmp.%s", tableName));
        this.checkForMetadataFile(tableName);
        int rowCount = TestParquetMetadataCache.testSql(String.format("select * from dfs_test.tmp.%s", tableName));
        Assert.assertEquals((long)25L, (long)rowCount);
    }

    private void checkForMetadataFile(String table) throws Exception {
        String tmpDir = TestParquetMetadataCache.getDfsTestTmpSchemaLocation();
        String metaFile = Joiner.on((String)"/").join((Object)tmpDir, (Object)table, new Object[]{".drill.parquet_metadata.v2"});
        Assert.assertTrue((boolean)Files.exists(new File(metaFile).toPath(), new LinkOption[0]));
    }
}

